/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ErrorsReportFilter {
    private static final Logger LOG = Logger.getLogger(ErrorsReportFilter.class);
    private int filterErrorCode;
    private String filterDatasetId;
    private Reader in;

    public Set<String> filter() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(this.in);
        String patternStr = this.filterDatasetId != null ? String.format("(%1$s), #(\\d+)", this.filterDatasetId) : String.format("(.+), #(%1$4d)", this.filterErrorCode);
        Pattern pattern = Pattern.compile(patternStr);
        HashSet<String> result = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String datasetId = matcher.group(1);
            String errorCode = matcher.group(2);
            if (this.filterDatasetId != null) {
                result.add(errorCode);
                continue;
            }
            result.add(datasetId);
        }
        return result;
    }

    public String getDatasetId() {
        return this.filterDatasetId;
    }

    public void setDatasetId(String datasetId) {
        this.filterDatasetId = datasetId;
    }

    public int getErrorCode() {
        return this.filterErrorCode;
    }

    public void setErrorCode(int errorCode) {
        this.filterErrorCode = errorCode;
    }

    public Reader getSource() {
        return this.in;
    }

    public void setSource(Reader source) {
        this.in = source;
    }
}

