/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorReportParser {
    private Set<String> datasetsWithErrors = new HashSet<String>();
    private Set<String> errors = new HashSet<String>();
    private int errorsCount;

    public void parse(Reader in) throws IOException {
        String line;
        this.errorsCount = 0;
        BufferedReader buf = new BufferedReader(in);
        Pattern pattern = Pattern.compile("(\\S+?), #(\\d{4})");
        while ((line = buf.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            ++this.errorsCount;
            String datasetId = matcher.group(1);
            String errorCode = matcher.group(2);
            this.processEntry(datasetId, errorCode);
        }
    }

    public void processEntry(String satzId, String errorCode) {
        this.datasetsWithErrors.add(satzId);
        this.errors.add(errorCode);
    }

    public int getDatasetWithErrorsCount() {
        return this.datasetsWithErrors.size();
    }

    public int getDifferentErrorsCount() {
        return this.errors.size();
    }

    public int getErrorsCount() {
        return this.errorsCount;
    }
}

