/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCodeIndexReportParser {
    private Map<String, String> messages = new HashMap<String, String>();

    public void parse(Reader in) throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(in);
        Pattern pattern = Pattern.compile("#(\\d{4}), (-?\\d*?), (.*)");
        while ((line = buf.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String errorCode = matcher.group(1);
            String errorHash = matcher.group(2);
            String errorMessage = matcher.group(3);
            this.processEntry(errorCode, errorHash, errorMessage);
        }
    }

    public void processEntry(String errorCode, String errorHash, String errorMessage) {
        this.messages.put(errorCode, errorMessage);
    }

    public String getMessageForCode(String errorCode) {
        return this.messages.get(errorCode);
    }
}

