/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.xml;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.parser.ContentHandler;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MabXmlHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(MabXmlHandler.class);
    private ContentHandler contentHandler;
    private String datasetId;
    private String datasetType;
    private String datasetStatus;
    private String feldnummer;
    private String indikator;
    private String unterfeldkennung;
    private StringBuilder content = new StringBuilder();
    private int datasetCount;
    private State status;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        LOG.debug((Object)("characters: " + new String(ch, start, length)));
        this.content.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        LOG.debug((Object)"endDocument");
        this.contentHandler.endParsing();
        this.status = State.NONE;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        LOG.debug((Object)("endElement " + qName));
        if ("datensatz".equals(qName)) {
            this.contentHandler.endSatz();
            this.status = State.IN_DOCUMENT;
            ++this.datasetCount;
        } else if ("feld".equals(qName)) {
            LOG.debug((Object)("field " + this.feldnummer + this.indikator + " = '" + this.content.toString() + "'"));
            this.contentHandler.startFeld(this.feldnummer, this.indikator.charAt(0), this.content.toString());
            this.status = State.IN_DATASET;
        } else if ("ns".equals(qName)) {
            this.content.append('\u009c');
        } else if ("stw".equals(qName)) {
            this.content.append('}');
        } else if ("uf".equals(qName)) {
            this.contentHandler.startUnterfeld(this.unterfeldkennung.charAt(0), this.content.toString());
            this.status = State.IN_FELD;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        LOG.debug((Object)"startDocument");
        try {
            this.contentHandler.startParsing();
        }
        catch (MableConfigurationException mce) {
            LOG.error((Object)mce);
            throw new SAXException("Error while starting parsing.", mce);
        }
        this.status = State.IN_DOCUMENT;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        LOG.debug((Object)("startElement " + qName));
        if ("datensatz".equals(qName)) {
            this.datasetId = attributes.getValue("id");
            LOG.debug((Object)("Parsing dataset id = " + this.datasetId));
            this.datasetType = attributes.getValue("typ");
            this.datasetStatus = attributes.getValue("status");
            MabSatzkennung satzkennung = new MabSatzkennung(0, this.datasetType, this.datasetStatus);
            this.contentHandler.startSatz(satzkennung);
        } else if ("feld".equals(qName)) {
            this.feldnummer = attributes.getValue("nr");
            this.indikator = attributes.getValue("ind");
            this.status = State.IN_FELD;
            this.content.setLength(0);
        } else if ("tf".equals(qName)) {
            this.content.append('\u2021');
        } else if ("ns".equals(qName)) {
            this.content.append('\u0098');
        } else if ("stw".equals(qName)) {
            this.content.append('{');
        } else if ("uf".equals(qName)) {
            this.unterfeldkennung = attributes.getValue("code");
            this.status = State.IN_UNTERFELD;
            this.content.setLength(0);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public int getDatasetsProcessed() {
        return this.datasetCount;
    }

    private static enum State {
        NONE,
        IN_DOCUMENT,
        IN_DATASET,
        IN_FELD,
        IN_UNTERFELD;

    }
}

