/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.validation;

import java.util.Arrays;
import org.apache.log4j.Logger;

public final class MabCharsetChecker {
    private static final Logger LOG = Logger.getLogger(MabCharsetChecker.class);
    public static final int VALID_CHARS_START = 29;
    public static final int VALID_CHARS_END = 126;
    public static final int[] VALID_CHARS = new int[]{152, 156, 161, 163, 165, 167, 171, 8225, 183, 187, 191, 847, 8222, 36, 8224, 8242, 8216, 8220, 9837, 169, 8471, 174, 699, 700, 8218, 8243, 8217, 8221, 9839, 697, 698, 777, 768, 769, 770, 771, 772, 774, 775, 776, 778, 789, 786, 779, 795, 780, 807, 796, 806, 808, 805, 814, 803, 804, 818, 819, 809, 813, 65056, 65057, 65059, 198, 272, 306, 321, 216, 338, 222, 230, 273, 240, 305, 307, 322, 248, 339, 223, 254, 7842, 7866, 7880, 7886, 7910, 7926, 7843, 7867, 7881, 7887, 7911, 7927, 192, 200, 204, 504, 210, 217, 7808, 7922, 224, 232, 236, 505, 242, 249, 7809, 7923, 193, 262, 201, 500, 205, 7728, 313, 7742, 323, 211, 7764, 340, 346, 218, 7810, 208, 377, 225, 263, 233, 501, 237, 7729, 314, 7743, 324, 243, 7765, 341, 347, 250, 7811, 253, 378, 550, 7682, 266, 7690, 278, 7710, 288, 7714, 304, 7744, 7748, 558, 7766, 7768, 7776, 7786, 7814, 7818, 7822, 379, 551, 7683, 267, 7691, 279, 7711, 289, 7715, 7745, 7749, 559, 7767, 7769, 7777, 7787, 7815, 7819, 7823, 380, 196, 203, 7718, 207, 214, 220, 7812, 7820, 391, 228, 235, 7719, 239, 246, 7831, 252, 7813, 7821, 255, 197, 366, 229, 367, 7832, 7833, 416, 431, 417, 432, 352, 353, 199, 7696, 552, 290, 7720, 310, 315, 325, 342, 350, 354, 126, 7697, 553, 291, 3625, 311, 316, 326, 343, 351, 355, 260, 280, 302, 490, 370, 261, 281, 303, 491, 371, 7840, 7864, 7736, 7884, 7770, 7778, 7841, 7865, 7735, 7885, 7771, 7779};

    public static boolean checkUTF8bytes(int input) {
        if (29 <= input && input <= 126 || Arrays.binarySearch(VALID_CHARS, input) >= 0) {
            return true;
        }
        LOG.debug((Object)String.format("Wrong character 0x%1$04X found.", input));
        return false;
    }

    private MabCharsetChecker() {
    }

    static {
        Arrays.sort(VALID_CHARS);
    }
}

