/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.log4j.Logger;

public class MabDatasetIndexer {
    private static final Logger LOG = Logger.getLogger(MabDatasetIndexer.class);
    public static final int CARRIAGERETURN = 13;
    public static final int LINEFEED = 10;
    private InputStream source;
    private Writer output;
    private int datasetCounter;
    private long position;
    private long datasetStart;

    public void init() {
        this.position = 0L;
        this.datasetStart = 0L;
        this.datasetCounter = 0;
    }

    public void index() throws IOException {
        String newLine = System.getProperty("line.separator");
        Writer out = this.getOutput();
        this.init();
        while (this.jumpTokens(24)) {
            ++this.datasetCounter;
            String currentId = "NONE";
            String category = this.readTokens(4);
            if ("001 ".equals(category)) {
                currentId = this.readFieldContent();
                LOG.debug((Object)("Found field 001 for " + currentId + " (" + this.datasetCounter + ")"));
            }
            String line = String.format("%1$s, %2$d" + newLine, currentId, this.datasetStart);
            out.write(line);
            this.jumpToNextDataset();
        }
    }

    private void jumpToNextDataset() throws IOException {
        while (this.nextToken() != 29) {
        }
        this.datasetStart = this.position;
    }

    private String readFieldContent() throws IOException {
        int token;
        StringBuilder content = new StringBuilder();
        while ((token = this.nextToken()) != -1 && token != 30) {
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private String readTokens(int length) throws IOException {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int token = this.nextToken();
            if (token == -1) {
                return null;
            }
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private int nextToken() throws IOException {
        int newChar = this.source.read();
        ++this.position;
        if (newChar == 10 || newChar == 13) {
            newChar = this.nextToken();
        }
        return newChar;
    }

    private boolean jumpTokens(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (this.nextToken() != -1) continue;
            return false;
        }
        return true;
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream source) {
        this.source = source;
    }

    public int getDatasetCounter() {
        return this.datasetCounter;
    }

    public Writer getOutput() {
        return this.output;
    }

    public void setOutput(Writer output) {
        this.output = output;
    }
}

