/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.log4j.Logger;

public class MabDatasetFinder {
    private static final Logger LOG = Logger.getLogger(MabDatasetFinder.class);
    public static final int CARRIAGERETURN = 13;
    public static final int LINEFEED = 10;
    public static final int MAX_DATASET_SIZE = 100000;
    private static final int BUFFER_SIZE = 8192;
    private InputStream source;
    private BufferedInputStream bufferedSource;
    private int datasetCounter;
    private byte[] buf;

    public void init() {
        this.datasetCounter = 0;
        this.buf = new byte[8192];
    }

    public byte[] find(String satzId) throws IOException {
        this.init();
        this.bufferedSource.mark(100000);
        while (this.jumpTokens(24)) {
            ++this.datasetCounter;
            this.bufferedSource.read(this.buf, 0, 4);
            String category = new String(this.buf, 0, 4);
            if ("001 ".equals(category)) {
                String currentId = this.readFieldContent();
                LOG.debug((Object)("Found field 001 for " + currentId + " (" + this.datasetCounter + ")"));
                if (satzId.equals(currentId)) {
                    LOG.debug((Object)("Satz '" + currentId + "' gefunden."));
                    return this.readDatasetBytes();
                }
            }
            this.jumpToNextDataset();
        }
        return null;
    }

    public void find(Set<String> identifiers, OutputStream output) throws IOException {
        this.init();
        LOG.debug((Object)("Searching for: " + identifiers));
        this.bufferedSource.mark(100000);
        while (this.jumpTokens(24) && identifiers.size() > 0) {
            ++this.datasetCounter;
            this.bufferedSource.read(this.buf, 0, 4);
            String category = new String(this.buf, 0, 4);
            if ("001 ".equals(category)) {
                String currentId = this.readFieldContent();
                LOG.debug((Object)("Found field 001 for " + currentId + " (" + this.datasetCounter + ")"));
                if (identifiers.remove(currentId)) {
                    LOG.debug((Object)("Satz '" + currentId + "' gefunden."));
                    output.write(this.readDatasetBytes());
                }
            }
            this.jumpToNextDataset();
        }
    }

    private byte[] readDatasetBytes() throws IOException {
        int token;
        this.bufferedSource.reset();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        while ((token = this.nextToken()) != -1) {
            content.write(token);
            if (token != 29) continue;
            break;
        }
        return content.toByteArray();
    }

    private void jumpToNextDataset() throws IOException {
        while (this.nextToken() != 29) {
        }
        this.bufferedSource.mark(100000);
    }

    private String readFieldContent() throws IOException {
        int token;
        StringBuilder content = new StringBuilder();
        while ((token = this.bufferedSource.read()) != -1 && token != 30) {
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private String readTokens(int length) throws IOException {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int token = this.nextToken();
            if (token == -1) {
                return null;
            }
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private int nextToken() throws IOException {
        int newChar = this.bufferedSource.read();
        if (newChar == 10 || newChar == 13) {
            newChar = this.nextToken();
        }
        return newChar;
    }

    private boolean jumpTokens(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (this.nextToken() != -1) continue;
            return false;
        }
        return true;
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream source) {
        this.source = source;
        this.bufferedSource = source != null ? (source instanceof BufferedInputStream ? (BufferedInputStream)source : new BufferedInputStream(source)) : null;
    }

    public int getDatasetCounter() {
        return this.datasetCounter;
    }
}

