/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class MabDatasetCounter {
    private static final Logger LOG = Logger.getLogger(MabDatasetCounter.class);
    private static final int BUFFER_SIZE = 8192;
    private Reader source;
    private int datasetCounter;

    public void init() {
        this.datasetCounter = 0;
    }

    public void parse() throws IOException {
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        LOG.debug((Object)("Using " + numberOfThreads + " counting threads."));
        CountDownLatch done = new CountDownLatch(numberOfThreads);
        CounterThread[] threads = new CounterThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new CounterThread(this.source, done);
            threads[i].start();
        }
        try {
            done.await();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Error counting datasets.", (Throwable)e);
        }
        for (CounterThread counter : threads) {
            this.datasetCounter += counter.getResult();
        }
    }

    public void reset() {
        this.datasetCounter = 0;
    }

    public Reader getSource() {
        return this.source;
    }

    public void setSource(Reader src) {
        this.source = src;
    }

    public int getDatasetCounter() {
        return this.datasetCounter;
    }

    private class CounterThread
    extends Thread {
        private Reader source;
        private CountDownLatch done;
        private int datasetCounter = 0;

        public CounterThread(Reader src, CountDownLatch latch) {
            this.source = src;
            this.done = latch;
        }

        @Override
        public void run() {
            char[] buf = new char[8192];
            int charsRead = 0;
            try {
                while ((charsRead = this.source.read(buf, 0, buf.length)) != -1) {
                    for (int i = 0; i < charsRead; ++i) {
                        if (buf[i] != '\u001d') continue;
                        ++this.datasetCounter;
                    }
                }
                this.done.countDown();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }

        public int getResult() {
            return this.datasetCounter;
        }
    }
}

