/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.parser;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.parser.AbstractMabParser;
import de.kobv.mable.mab.parser.MabParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FastMabParser
extends AbstractMabParser
implements MabParser {
    private static final Logger LOG = Logger.getLogger(FastMabParser.class);
    public static final int CARRIAGERETURN = 13;
    public static final int LINEFEED = 10;
    public static final int MAX_DATASET_SIZE = 100000;
    private static final int BUFFER_SIZE = 8192;
    private InputStream source;
    private BufferedInputStream bufferedSource;
    private int datasetCounter;
    private int lastToken;
    private Set contentForCategories = new HashSet();

    private void init() {
        this.datasetCounter = 0;
    }

    @Override
    public void parse() throws IOException, MableConfigurationException {
        String satzkennung;
        this.getContentHandler().startParsing();
        this.init();
        this.bufferedSource.mark(100000);
        while ((satzkennung = this.readTokens(24)) != null) {
            ++this.datasetCounter;
            LOG.debug((Object)("Satzkennung (" + this.datasetCounter + "): " + satzkennung));
            MabSatzkennung msk = new MabSatzkennung();
            msk.setValue(satzkennung);
            this.getContentHandler().startSatz(msk);
            LOG.debug((Object)"Read fields");
            this.readFields();
        }
        this.getContentHandler().endParsing();
    }

    private void readFields() throws IOException {
        String category;
        while ((category = this.readCategory()) != null) {
            String feldnummer = category.substring(0, 3);
            String content = null;
            if (this.contentForCategories.contains(feldnummer)) {
                content = this.readFieldContent();
                LOG.debug((Object)("    Content (" + category + "): '" + content + "'"));
            }
            this.getContentHandler().startFeld(feldnummer, category.charAt(3), content);
            if (this.lastToken == 29) break;
            if (this.lastToken == 30) continue;
            this.jumpToNextField();
            if (this.lastToken != 29) continue;
            break;
        }
        this.getContentHandler().endSatz();
    }

    private void jumpToNextField() throws IOException {
        int token;
        while ((token = this.nextToken()) != -1 && token != 30 && token != 29) {
        }
    }

    private String readFieldContent() throws IOException {
        int token;
        StringBuilder content = new StringBuilder();
        while ((token = this.nextToken()) != -1 && token != 30 && token != 29) {
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private String readTokens(int length) throws IOException {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int token = this.nextToken();
            if (token == -1) {
                return null;
            }
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private String readCategory() throws IOException {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int token = this.nextToken();
            if (token == -1 || token == 29) {
                return null;
            }
            content.append(Character.toString((char)token));
        }
        return content.toString();
    }

    private int nextToken() throws IOException {
        int newChar = this.bufferedSource.read();
        if (newChar == 10 || newChar == 13) {
            newChar = this.nextToken();
        }
        this.lastToken = newChar;
        return newChar;
    }

    @Override
    public void setSource(InputStream source) {
        this.source = source;
        this.bufferedSource = source != null ? (source instanceof BufferedInputStream ? (BufferedInputStream)source : new BufferedInputStream(source)) : null;
    }

    @Override
    public int getDatasetsProcessed() {
        return this.datasetCounter;
    }

    @Override
    public int getDatasetsIgnored() {
        return 0;
    }

    @Override
    public void setSource(Reader source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setContentForCategories(Set categories) {
        this.contentForCategories = categories;
    }
}

