/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.parser;

import de.kobv.mable.ErrorCode;
import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.parser.ContentHandler;
import de.kobv.mable.mab.parser.ErrorHandler;
import de.kobv.mable.mab.parser.MabParser;
import de.kobv.mable.mab.validation.MabCharsetChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Queue;

public class DefaultMabParser
implements MabParser {
    private static final int BUFFER_SIZE = 8192;
    private static final int HEADER_LENGTH = 24;
    public static final int CARRIAGERETURN = 13;
    public static final int LINEFEED = 10;
    private Reader in;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private Zustand zustand;
    private int position;
    private StringBuilder puffer;
    private Queue<Character> toInsert;
    private Queue<ErrorCode> fehlerPuffer;
    private boolean datenIgnoriert;
    private ErrorCode ignoredDatasetError;
    private String ignoredDatasetId;
    private boolean inNichtsortiert;
    private boolean inStichwort;
    private boolean printSatzInfos;
    private int saetzeGefunden;
    private int saetzeIgnoriert;
    private String sFeldnummer;
    private int iFeldnummer;
    private char feldindikator;
    private char unterfeldkennzeichen;
    private boolean checkFirstField = false;

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setSource(Reader source) {
        this.in = source instanceof BufferedReader ? source : new BufferedReader(source, 8192);
    }

    public void init() {
        this.zustand = Zustand.UNDEFINIERT;
        this.position = 0;
        this.puffer = new StringBuilder();
        this.fehlerPuffer = new LinkedList<ErrorCode>();
        this.datenIgnoriert = false;
        this.toInsert = new LinkedList<Character>();
        this.inNichtsortiert = false;
        this.inStichwort = false;
        this.printSatzInfos = false;
        this.saetzeGefunden = 0;
        this.saetzeIgnoriert = 0;
        this.iFeldnummer = -1;
        this.sFeldnummer = "";
        this.unterfeldkennzeichen = (char)35;
    }

    @Override
    public void parse() throws IOException, ParseException, MableConfigurationException {
        int input;
        this.init();
        this.contentHandler.startParsing();
        this.zustand = Zustand.IN_DOKUMENT;
        block8: while ((input = this.nextToken()) != -1) {
            char inputChar = (char)input;
            switch (this.zustand) {
                case IN_DOKUMENT: {
                    this.parseInDocument(inputChar);
                    continue block8;
                }
                case IN_SATZ: {
                    this.parseInSatz(inputChar);
                    continue block8;
                }
                case IN_FELD: {
                    this.parseInFeld(inputChar);
                    continue block8;
                }
                case NACH_UNTERFELDSTART: {
                    this.parseNachUnterfeldStart(inputChar);
                    continue block8;
                }
                case IN_UNTERFELD: {
                    this.parseInUnterfeld(inputChar);
                    continue block8;
                }
                case IGNORIERE_SATZ: {
                    this.parseIgnoredDataset(inputChar);
                    continue block8;
                }
            }
            throw new ParseException("undefinierten Zustand erreicht. Bitte den Entwickler benachrichtigen.", this.position);
        }
        this.finishParsing();
    }

    protected void parseInDocument(char inputChar) throws IOException {
        switch (inputChar) {
            case '\u001e': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.FELDENDE_OHNE_SATZ);
                break;
            }
            case '\u0098': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.NICHTSORTIERBEGINN_OHNE_SATZ);
                break;
            }
            case '\u009c': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.NICHTSORTIERENDE_OHNE_SATZ);
                break;
            }
            case '\u001d': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.SATZENDE_OHNE_SATZ);
                break;
            }
            case '{': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.STICHWORTBEGINN_OHNE_SATZ);
                break;
            }
            case '}': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.STICHWORTENDE_OHNE_SATZ);
                break;
            }
            case '\u2021': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.TEILFELDTRENNUNG_OHNE_SATZ);
                break;
            }
            case '\u001f': {
                this.errorHandler.insertLieferungsfehler(ErrorCode.UNTERFELDBEGINN_OHNE_SATZ);
                break;
            }
            default: {
                this.parseSatzkennung(inputChar);
                if (this.zustand != Zustand.IGNORIERE_SATZ) break;
                this.checkFirstField = true;
            }
        }
    }

    protected void parseSatzkennung(char inputChar) throws IOException {
        this.puffer.append(inputChar);
        boolean eof = false;
        for (int i = 0; i < 23 && !eof; ++i) {
            int input = this.nextToken();
            if (input != -1) {
                this.puffer.append((char)input);
                continue;
            }
            eof = true;
        }
        if (eof) {
            this.errorHandler.insertLieferungsfehler(ErrorCode.EOF_IN_SATZKENNUNG);
            return;
        }
        MabSatzkennung satzkennung = new MabSatzkennung();
        assert (this.puffer.length() == 24);
        satzkennung.setValue(this.puffer.substring(0, 24));
        if (!satzkennung.isLengthValid()) {
            this.ignoredDatasetError = ErrorCode.SATZLAENGE_UNZULAESSIG;
            this.zustand = Zustand.IGNORIERE_SATZ;
            return;
        }
        if (!satzkennung.isStatusValid()) {
            this.ignoredDatasetError = ErrorCode.SATZSTATUS_UNZULAESSIG;
            this.zustand = Zustand.IGNORIERE_SATZ;
            return;
        }
        if (!satzkennung.isVersionValid()) {
            this.fehlerPuffer.add(ErrorCode.VERSIONSANGABE_UNZULAESSIG);
        }
        if (!satzkennung.isIndicatorLengthValid()) {
            this.ignoredDatasetError = ErrorCode.INDIKATORLAENGE_UNZULAESSIG;
            this.zustand = Zustand.IGNORIERE_SATZ;
            return;
        }
        if (!satzkennung.isTeilfeldkennungslaengeValid()) {
            this.fehlerPuffer.add(ErrorCode.TEILFELDKENNUNGSLAENGE_UNZULAESSIG);
        }
        if (!satzkennung.isDataStartAddressValid()) {
            this.ignoredDatasetError = ErrorCode.DATENANFANGSADRESSE_UNZULAESSIG;
            this.zustand = Zustand.IGNORIERE_SATZ;
            return;
        }
        if (!satzkennung.isReservedFieldsEmpty()) {
            this.fehlerPuffer.add(ErrorCode.RESERVIERTEZEICHEN_UNZULAESSIG);
        }
        if (!satzkennung.isTypeValid()) {
            this.fehlerPuffer.add(ErrorCode.SATZTYP_UNZULAESSIG);
        }
        this.contentHandler.startSatz(satzkennung);
        this.errorHandler.insertSatzfehler(this.fehlerPuffer);
        this.fehlerPuffer.clear();
        this.puffer.setLength(0);
        this.zustand = Zustand.IN_SATZ;
    }

    protected void parseInSatz(char inputChar) throws IOException {
        switch (inputChar) {
            case '\u001e': {
                this.errorHandler.insertSatzfehler(ErrorCode.FELDENDE_OHNE_FELD);
                break;
            }
            case '\u0098': {
                this.errorHandler.insertSatzfehler(ErrorCode.NICHTSORTIERBEGINN_OHNE_FELD);
                break;
            }
            case '\u009c': {
                this.errorHandler.insertSatzfehler(ErrorCode.NICHTSORTIERENDE_OHNE_FELD);
                break;
            }
            case '\u001d': {
                this.beendeSatz();
                break;
            }
            case '{': {
                this.errorHandler.insertSatzfehler(ErrorCode.STICHWORTBEGINN_OHNE_FELD);
                break;
            }
            case '}': {
                this.errorHandler.insertSatzfehler(ErrorCode.STICHWORTENDE_OHNE_FELD);
                break;
            }
            case '\u2021': {
                this.errorHandler.insertSatzfehler(ErrorCode.TEILFELDTRENNUNG_OHNE_FELD);
                break;
            }
            case '\u001f': {
                this.errorHandler.insertSatzfehler(ErrorCode.UNTERFELDBEGINN_OHNE_FELD);
                break;
            }
            default: {
                String feldnummer;
                int fnr2 = this.nextToken();
                int fnr3 = this.nextToken();
                if (fnr2 == -1 || fnr3 == -1) {
                    this.errorHandler.insertLieferungsfehler(ErrorCode.EOF_IN_FELDNUMMER);
                    break;
                }
                this.sFeldnummer = feldnummer = Character.toString(inputChar) + Character.toString((char)fnr2) + Character.toString((char)fnr3);
                try {
                    this.iFeldnummer = Integer.parseInt(this.sFeldnummer);
                }
                catch (NumberFormatException nfe) {
                    this.sFeldnummer = "-1";
                    this.iFeldnummer = -1;
                }
                if (this.iFeldnummer <= 0) {
                    this.ignoriereFeld(feldnummer, ErrorCode.FELDNUMMER_FORMATFEHLER);
                    break;
                }
                int iIndikator = this.nextToken();
                if (iIndikator == -1) {
                    this.errorHandler.insertLieferungsfehler(ErrorCode.EOF_IN_FELDINDIKATOR);
                    break;
                }
                this.feldindikator = (char)iIndikator;
                if (!Character.toString(this.feldindikator).matches("[a-zA-Z0-9 ]")) {
                    this.ignoriereFeld(this.sFeldnummer + Character.toString(this.feldindikator), ErrorCode.FELDINDIKATOR_FORMATFEHLER);
                    break;
                }
                this.zustand = Zustand.IN_FELD;
            }
        }
    }

    protected void parseInFeld(char inputChar) throws IOException {
        switch (inputChar) {
            case '\u001e': {
                this.commonParseCode();
                if (this.puffer.length() <= 0) {
                    this.fehlerPuffer.add(ErrorCode.LEERES_FELD);
                }
                this.contentHandler.startFeld(this.sFeldnummer, this.feldindikator, this.puffer.toString());
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, this.fehlerPuffer);
                this.resetFeld();
                this.zustand = Zustand.IN_SATZ;
                break;
            }
            case '\u0098': {
                if (this.inNichtsortiert) {
                    this.fehlerPuffer.add(ErrorCode.WIEDERHOLTER_NICHTSORTIERBEGINN_IN_FELD);
                }
                this.inNichtsortiert = true;
                this.puffer.append(inputChar);
                break;
            }
            case '\u009c': {
                if (!this.inNichtsortiert) {
                    this.fehlerPuffer.add(ErrorCode.FEHLENDER_NICHTSORTIERBEGINN_IN_FELD);
                }
                this.puffer.append(inputChar);
                this.inNichtsortiert = false;
                break;
            }
            case '\u001d': {
                this.fehlerPuffer.add(ErrorCode.SATZENDE_IN_FELD);
                this.toInsert.add(Character.valueOf('\u001e'));
                this.toInsert.add(Character.valueOf(inputChar));
                break;
            }
            case '{': {
                if (this.inStichwort) {
                    this.fehlerPuffer.add(ErrorCode.WIEDERHOLTER_STICHWORTBEGINN_IN_FELD);
                }
                this.inStichwort = true;
                this.puffer.append(inputChar);
                break;
            }
            case '}': {
                if (!this.inStichwort) {
                    this.fehlerPuffer.add(ErrorCode.FEHLENDER_STICHWORTBEGINN_IN_FELD);
                }
                this.inStichwort = false;
                this.puffer.append(inputChar);
                break;
            }
            case '\u2021': {
                this.puffer.append(inputChar);
                break;
            }
            case '\u001f': {
                if (this.puffer.length() > 0) {
                    this.ignoriereFeld(this.sFeldnummer + Character.toString(this.feldindikator) + this.puffer.toString(), ErrorCode.FELDINHALT_UND_UNTERFELD_VORHANDEN);
                    break;
                }
                if (!MabFeldDefinition.isMab2Field(this.iFeldnummer, this.feldindikator, false)) {
                    this.fehlerPuffer.add(ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
                }
                this.contentHandler.startFeld(this.sFeldnummer, this.feldindikator, null);
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, this.fehlerPuffer);
                this.fehlerPuffer.clear();
                this.zustand = Zustand.NACH_UNTERFELDSTART;
                break;
            }
            default: {
                if (!MabCharsetChecker.checkUTF8bytes(inputChar)) {
                    this.fehlerPuffer.add(ErrorCode.ZEICHENSATZ_FEHLER);
                }
                this.puffer.append(inputChar);
            }
        }
    }

    protected void parseNachUnterfeldStart(char inputChar) throws IOException {
        switch (inputChar) {
            case '\u001e': {
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, ErrorCode.FELDENDE_STATT_UFKENNZEICHEN);
                this.resetFeld();
                this.zustand = Zustand.IN_SATZ;
                break;
            }
            case '\u0098': {
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, ErrorCode.NICHTSORTIERBEGINN_STATT_UFKENNZEICHEN);
                this.ignoriereUnterfeld(Character.toString(inputChar), ErrorCode.NICHTSORTIERBEGINN_STATT_UFKENNZEICHEN);
                break;
            }
            case '\u009c': {
                this.ignoriereUnterfeld(Character.toString(inputChar), ErrorCode.NICHTSORTIERENDE_STATT_UFKENNZEICHEN);
                break;
            }
            case '\u001d': {
                this.errorHandler.insertSatzfehler(ErrorCode.SATZENDE_STATT_UFKENNZEICHEN);
                this.resetUnterfeld();
                this.resetFeld();
                this.beendeSatz();
                break;
            }
            case '{': {
                this.ignoriereUnterfeld(Character.toString(inputChar), ErrorCode.STICHWORTBEGINN_STATT_UFKENNZEICHEN);
                break;
            }
            case '}': {
                this.ignoriereUnterfeld(Character.toString(inputChar), ErrorCode.STICHWORTENDE_STATT_UFKENNZEICHEN);
                break;
            }
            case '\u2021': {
                this.ignoriereUnterfeld(Character.toString(inputChar), ErrorCode.TEILFELDTRENNUNG_STATT_UFKENNZEICHEN);
                break;
            }
            case '\u001f': {
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, ErrorCode.UNTERFELDBEGINN_STATT_UFKENNZEICHEN);
                break;
            }
            default: {
                this.unterfeldkennzeichen = inputChar;
                if (!Character.toString(this.unterfeldkennzeichen).matches("[a-zA-Z0-9 ]")) {
                    this.ignoriereUnterfeld(Character.toString(inputChar), ErrorCode.UFKENNZEICHEN_FORMATFEHLER);
                    break;
                }
                this.zustand = Zustand.IN_UNTERFELD;
            }
        }
    }

    protected void parseInUnterfeld(char inputChar) {
        switch (inputChar) {
            case '\u001e': {
                this.beendeUnterfeld();
                this.resetFeld();
                this.zustand = Zustand.IN_SATZ;
                break;
            }
            case '\u0098': {
                if (this.inNichtsortiert) {
                    this.fehlerPuffer.add(ErrorCode.WIEDERHOLTER_NICHTSORTIERBEGINN_IN_UFELD);
                }
                this.inNichtsortiert = true;
                this.puffer.append(inputChar);
                break;
            }
            case '\u009c': {
                if (!this.inNichtsortiert) {
                    this.fehlerPuffer.add(ErrorCode.FEHLENDER_NICHTSORTIERBEGINN_IN_UFELD);
                }
                this.inNichtsortiert = false;
                this.puffer.append(inputChar);
                break;
            }
            case '\u001d': {
                this.fehlerPuffer.add(ErrorCode.SATZENDE_IN_UFELD);
                this.toInsert.add(Character.valueOf('\u001e'));
                this.toInsert.add(Character.valueOf(inputChar));
                break;
            }
            case '{': {
                if (this.inStichwort) {
                    this.fehlerPuffer.add(ErrorCode.WIEDERHOLTER_STICHWORTBEGINN_IN_UFELD);
                }
                this.inStichwort = true;
                this.puffer.append(inputChar);
                break;
            }
            case '}': {
                if (!this.inStichwort) {
                    this.fehlerPuffer.add(ErrorCode.FEHLENDER_STICHWORTBEGINN_IN_UFELD);
                }
                this.inStichwort = false;
                this.puffer.append(inputChar);
                break;
            }
            case '\u2021': {
                this.puffer.append(inputChar);
                break;
            }
            case '\u001f': {
                this.beendeUnterfeld();
                this.zustand = Zustand.NACH_UNTERFELDSTART;
                break;
            }
            default: {
                if (!MabCharsetChecker.checkUTF8bytes(inputChar)) {
                    this.fehlerPuffer.add(ErrorCode.ZEICHENSATZ_FEHLER);
                }
                this.puffer.append(inputChar);
            }
        }
    }

    protected void parseIgnoredDataset(char inputChar) throws IOException {
        this.datenIgnoriert = true;
        this.printSatzInfos = true;
        this.puffer.append(inputChar);
        switch (inputChar) {
            case '\u001e': {
                this.checkForField001(inputChar);
                break;
            }
            case '\u001d': {
                this.errorHandler.rejectDataset(this.ignoredDatasetError, this.ignoredDatasetId, this.puffer.toString(), false);
                this.ignoredDatasetError = null;
                this.ignoredDatasetId = null;
                this.resetFeld();
                ++this.saetzeIgnoriert;
                this.printSatzInfos = false;
                this.fehlerPuffer.clear();
                this.zustand = Zustand.IN_DOKUMENT;
                break;
            }
            default: {
                if (!this.checkFirstField) break;
                this.checkForField001(inputChar);
                this.checkFirstField = false;
            }
        }
    }

    protected void checkForField001(char inputChar) throws IOException {
        int fnr2 = this.nextToken();
        int fnr3 = this.nextToken();
        if (fnr2 == -1 || fnr3 == -1) {
            return;
        }
        if ((char)fnr2 == '\u001d') {
            this.toInsert.add(Character.valueOf((char)fnr2));
            this.toInsert.add(Character.valueOf((char)fnr3));
            return;
        }
        if ((char)fnr3 == '\u001d') {
            this.puffer.append((char)fnr2);
            this.toInsert.add(Character.valueOf((char)fnr3));
            return;
        }
        this.puffer.append((char)fnr2);
        this.puffer.append((char)fnr3);
        if (inputChar == '0' && (char)fnr2 == '0' && (char)fnr3 == '1') {
            int iIndikator = this.nextToken();
            if (iIndikator == -1) {
                return;
            }
            char cIndikator = (char)iIndikator;
            if (cIndikator == '\u001d') {
                this.toInsert.add(Character.valueOf(cIndikator));
                return;
            }
            this.puffer.append(cIndikator);
            if (cIndikator == ' ') {
                int input;
                String feldinhalt = "";
                do {
                    input = this.nextToken();
                    feldinhalt = feldinhalt + Character.toString((char)input);
                } while (input != -1 && input != 30 && input != 29);
                if (input == 29) {
                    this.puffer.append(feldinhalt);
                    this.toInsert.add(Character.valueOf((char)input));
                    return;
                }
                if (input == -1) {
                    this.puffer.append(feldinhalt);
                    return;
                }
                if (feldinhalt.length() > 0) {
                    this.ignoredDatasetId = feldinhalt.substring(0, feldinhalt.length() - 1);
                    this.puffer.append(feldinhalt);
                }
            }
        }
    }

    protected void finishParsing() throws ParseException {
        switch (this.zustand) {
            case IN_DOKUMENT: {
                break;
            }
            case IN_FELD: {
                this.fehlerPuffer.add(ErrorCode.EOF_IN_FELD);
                this.commonParseCode();
                this.contentHandler.startFeld(this.sFeldnummer, this.feldindikator, this.puffer.toString());
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, this.fehlerPuffer);
                this.resetFeld();
                this.beendeSatz();
                this.datenIgnoriert = true;
                break;
            }
            case IN_SATZ: {
                this.beendeSatz();
                this.errorHandler.insertLieferungsfehler(ErrorCode.EOF_IN_SATZ);
                this.datenIgnoriert = true;
                break;
            }
            case IGNORIERE_SATZ: {
                this.datenIgnoriert = true;
                this.errorHandler.rejectDataset(this.ignoredDatasetError, this.ignoredDatasetId, this.puffer.toString(), true);
                this.ignoredDatasetError = null;
                this.ignoredDatasetId = null;
                ++this.saetzeIgnoriert;
                break;
            }
            case NACH_UNTERFELDSTART: {
                this.errorHandler.insertFeldfehler(this.sFeldnummer + this.feldindikator, ErrorCode.EOF_STATT_UFKENNZEICHEN);
                this.beendeSatz();
                this.datenIgnoriert = true;
                break;
            }
            default: {
                throw new ParseException("Parsen abgeschlossen, ohne Datei zu \u00f6ffnen. Zustand des Parsers ist undefiniert. Bitte den Entwickler kontaktieren.", this.position);
            }
        }
        if (this.datenIgnoriert) {
            this.errorHandler.insertLieferungsfehler(ErrorCode.LIEFERUNG_UNVOLLSTAENDIG);
        }
        this.contentHandler.endParsing();
    }

    protected void commonParseCode() {
        if (this.inNichtsortiert) {
            this.fehlerPuffer.add(ErrorCode.FEHLENDES_NICHTSORTIERENDE_IN_FELD);
        }
        if (this.inStichwort) {
            this.fehlerPuffer.add(ErrorCode.FEHLENDES_STICHWORTENDE_IN_FELD);
        }
        if (!MabFeldDefinition.isMab2Field(this.iFeldnummer, this.feldindikator, true)) {
            if (!MabFeldDefinition.isMab2Field(this.iFeldnummer, this.feldindikator, false)) {
                this.fehlerPuffer.add(ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
            } else {
                this.fehlerPuffer.add(ErrorCode.FEHLENDES_UNTERFELD);
            }
        }
    }

    private int nextToken() throws IOException {
        int newChar;
        if (this.toInsert.size() > 0) {
            newChar = this.toInsert.poll().charValue();
        } else {
            ++this.position;
            newChar = this.in.read();
        }
        if (newChar == 10 || newChar == 13) {
            newChar = this.nextToken();
        }
        return newChar;
    }

    private void ignoriereFeld(String fieldData, ErrorCode error) throws IOException {
        char inputChar;
        int input;
        String fetchedFieldData = fieldData;
        this.datenIgnoriert = true;
        this.printSatzInfos = true;
        do {
            input = this.nextToken();
            inputChar = (char)input;
            fetchedFieldData = fetchedFieldData + Character.toString(inputChar);
        } while (input != -1 && inputChar != '\u001e' && inputChar != '\u001d');
        this.errorHandler.rejectField(error, fetchedFieldData);
        if (input == -1) {
            this.errorHandler.addRejectError(ErrorCode.EOF_IN_FELD);
            return;
        }
        if (inputChar == '\u001d') {
            this.errorHandler.addRejectError(ErrorCode.SATZENDE_IN_FELD);
            this.resetFeld();
            this.beendeSatz();
            return;
        }
        this.resetFeld();
        this.zustand = Zustand.IN_SATZ;
    }

    private void resetFeld() {
        this.feldindikator = (char)35;
        this.iFeldnummer = -1;
        this.sFeldnummer = "";
        this.inNichtsortiert = false;
        this.inStichwort = false;
        this.unterfeldkennzeichen = (char)35;
        this.puffer.setLength(0);
        this.fehlerPuffer.clear();
    }

    private void ignoriereUnterfeld(String fetchedSubfieldData, ErrorCode error) throws IOException {
        char inputChar;
        int input;
        String subfieldData = fetchedSubfieldData;
        this.datenIgnoriert = true;
        this.printSatzInfos = true;
        do {
            input = this.nextToken();
            inputChar = (char)input;
            subfieldData = subfieldData + Character.toString(inputChar);
        } while (input != -1 && inputChar != '\u001e' && inputChar != '\u001f' && inputChar != '\u001d');
        this.errorHandler.rejectSubfield(error, subfieldData);
        if (input == -1) {
            this.errorHandler.addRejectError(ErrorCode.EOF_IN_UFELD);
        } else if (inputChar == '\u001e') {
            this.resetUnterfeld();
            this.resetFeld();
            this.zustand = Zustand.IN_SATZ;
        } else if (inputChar == '\u001f') {
            this.resetUnterfeld();
            this.zustand = Zustand.NACH_UNTERFELDSTART;
        } else {
            this.errorHandler.addRejectError(ErrorCode.SATZENDE_IN_UFELD);
            this.resetUnterfeld();
            this.resetFeld();
            this.beendeSatz();
        }
    }

    private void resetUnterfeld() {
        this.inNichtsortiert = false;
        this.inStichwort = false;
        this.unterfeldkennzeichen = (char)35;
        this.puffer.setLength(0);
        this.fehlerPuffer.clear();
    }

    private void beendeUnterfeld() {
        if (!MabFeldDefinition.isMabSubfield(this.iFeldnummer, this.feldindikator, this.unterfeldkennzeichen)) {
            this.fehlerPuffer.add(ErrorCode.UNZULAESSIGES_UNTERFELD);
        }
        this.contentHandler.startUnterfeld(this.unterfeldkennzeichen, this.puffer.toString());
        this.errorHandler.insertUnterfeldfehler(this.fehlerPuffer);
        this.resetUnterfeld();
    }

    private void beendeSatz() {
        ++this.saetzeGefunden;
        if (this.printSatzInfos) {
            this.errorHandler.endReject();
            this.printSatzInfos = false;
        }
        this.contentHandler.endSatz();
        this.resetFeld();
        this.zustand = Zustand.IN_DOKUMENT;
    }

    @Override
    public int getDatasetsProcessed() {
        return this.saetzeGefunden;
    }

    @Override
    public int getDatasetsIgnored() {
        return this.saetzeIgnoriert;
    }

    @Override
    public void setSource(InputStream stream) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private static enum Zustand {
        UNDEFINIERT,
        IN_DOKUMENT,
        IN_SATZ,
        IGNORIERE_SATZ,
        IN_FELD,
        NACH_UNTERFELDSTART,
        IN_UNTERFELD;

    }
}

