/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.extension.ErrorCodeAlreadyExistsException;
import de.kobv.mable.mab.extension.ErrorCodeManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class ErrorType
implements Comparable<ErrorType> {
    private static final Logger LOG = Logger.getLogger(ErrorType.class);
    private int errorCode;
    private boolean errorCodeRegistered = false;
    private String message;
    private static Properties messages;
    private static final ErrorCodeManager errorCodeFactory;

    public ErrorType() {
        this(null, 0);
    }

    public ErrorType(String message) {
        this(message, 0);
    }

    public ErrorType(String message, int code) {
        this.errorCode = code;
        this.message = message;
    }

    public abstract int getHash();

    public int getCodeHash() {
        return this.getHash();
    }

    public int getCode() {
        if (!this.errorCodeRegistered) {
            if (this.errorCode != 0) {
                try {
                    errorCodeFactory.registerCode(this.getCodeHash(), this.errorCode);
                }
                catch (ErrorCodeAlreadyExistsException e) {
                    this.errorCode = errorCodeFactory.generateCode(this.getCodeHash());
                }
            } else {
                this.errorCode = errorCodeFactory.generateCode(this.getCodeHash());
            }
            this.errorCodeRegistered = true;
        }
        return this.errorCode;
    }

    public String getMessage() {
        String msg = this.message;
        Properties messages = ErrorType.getMessages();
        if (this.message != null && messages.containsKey(this.message)) {
            msg = messages.getProperty(this.message);
        }
        return msg;
    }

    public int hashCode() {
        return this.getHash();
    }

    @Override
    public int compareTo(ErrorType o) {
        return Integer.compare(this.getCode(), o.getCode());
    }

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass() && this.hashCode() == obj.hashCode();
    }

    public static Properties getMessages() {
        if (messages == null) {
            messages = new Properties();
            try {
                InputStream in = ErrorType.class.getClassLoader().getResourceAsStream("de/kobv/mable/messages.xml");
                messages.loadFromXML(in);
            }
            catch (IOException ioe) {
                LOG.error((Object)"messages.xml not found");
            }
        }
        return messages;
    }

    public static String getMessage(String key) {
        Properties messages = ErrorType.getMessages();
        if (messages.containsKey(key)) {
            return messages.getProperty(key);
        }
        return key;
    }

    protected String getFeldname(String kategorie) {
        try {
            MabFeldDefinition feldDef = MabFeldDefinition.valueOf("MAB" + kategorie);
            if (feldDef != null) {
                return feldDef.getName();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    static {
        errorCodeFactory = new ErrorCodeManager();
    }
}

