/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.ErrorCode;
import de.kobv.mable.mab.extension.CodeErrorType;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorLogger;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab.extension.FieldErrorType;
import de.kobv.mable.mab.extension.FieldErrorTypeComparator;
import de.kobv.mable.mab.extension.FormatErrorType;
import de.kobv.mable.mab.extension.IErrorStatistics;
import de.kobv.mable.mab.extension.PackageErrorType;
import de.kobv.mable.mab.extension.SubfieldErrorType;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ErrorStatistics
implements IErrorStatistics {
    private static final Logger LOG = Logger.getLogger(ErrorStatistics.class);
    private Map<ErrorType, Integer> fehler = new HashMap<ErrorType, Integer>();
    private ErrorLogger errorLog;
    private String current001;

    @Override
    public void addError(DatasetError error) {
        ErrorType errorType = error.getErrorType();
        if (errorType == null) {
            System.out.println(this + " error without type : " + error);
            throw new NullPointerException("error without error type");
        }
        int count = 0;
        if (this.fehler.containsKey(errorType)) {
            count = this.fehler.get(errorType);
        }
        this.fehler.put(errorType, count + 1);
        this.errorLog.logError(error);
    }

    protected void addError(ErrorType errorType) {
        int count = 0;
        if (this.fehler.containsKey(errorType)) {
            count = this.fehler.get(errorType);
        }
        this.fehler.put(errorType, count + 1);
    }

    public void addFieldError(String fieldType, ErrorCode errorCode) {
        FieldErrorType errorType = new FieldErrorType(fieldType, errorCode);
        this.addError(errorType);
        this.errorLog.logError(this.getError(errorType));
    }

    public void addFormatError(ErrorCode errorCode) {
        FormatErrorType errorType = new FormatErrorType(errorCode);
        this.addError(errorType);
        this.errorLog.logError(this.getError(errorType));
    }

    public void addPackageError(ErrorCode errorCode) {
        PackageErrorType errorType = new PackageErrorType(errorCode);
        this.addError(errorType);
        this.errorLog.logError(this.getError(errorType));
    }

    public void addSubfieldError(ErrorCode errorCode) {
        SubfieldErrorType errorType = new SubfieldErrorType(errorCode);
        this.addError(errorType);
        this.errorLog.logError(this.getError(errorType));
    }

    public Map<ErrorType, Integer> getErrors(Class errorTypeClass) {
        TreeMap<ErrorType, Integer> result = new TreeMap<ErrorType, Integer>();
        for (Map.Entry<ErrorType, Integer> entry : this.fehler.entrySet()) {
            if (!errorTypeClass.isInstance(entry.getKey())) continue;
            result.put(entry.getKey(), 1);
        }
        return result;
    }

    public Map<ErrorType, Integer> getPackageErrors() {
        return this.getErrors(PackageErrorType.class);
    }

    public Map<ErrorType, Integer> getFormatErrors() {
        return this.getErrors(FormatErrorType.class);
    }

    public Map<FieldErrorType, Integer> getFieldErrors() {
        TreeMap<FieldErrorType, Integer> result = new TreeMap<FieldErrorType, Integer>(new FieldErrorTypeComparator());
        for (Map.Entry<ErrorType, Integer> entry : this.fehler.entrySet()) {
            if (!(entry.getKey() instanceof FieldErrorType)) continue;
            result.put((FieldErrorType)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<ErrorType, Integer> getSubfieldErrors() {
        return this.getErrors(SubfieldErrorType.class);
    }

    @Override
    public Map<ErrorType, Integer> getDatasetErrors() {
        TreeMap<ErrorType, Integer> result = new TreeMap<ErrorType, Integer>();
        for (Map.Entry<ErrorType, Integer> entry : this.fehler.entrySet()) {
            if (entry.getKey() instanceof CodeErrorType) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public void writeIndex(PrintWriter out) {
        for (ErrorType errorType : this.fehler.keySet()) {
            out.println(String.format("#%1$s, %2$d, %3$s", errorType.getCode(), errorType.getHash(), errorType.getMessage()));
        }
    }

    public void setCurrentDataset001(String current001) {
        this.current001 = current001;
    }

    @Autowired
    @Required
    public void setErrorLog(ErrorLogger errorLog) {
        this.errorLog = errorLog;
    }

    private DatasetError getError(ErrorType errorType) {
        return new DatasetError(errorType, this.current001);
    }
}

