/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.mab.extension.ErrorCodeAlreadyExistsException;
import java.util.HashMap;
import java.util.Map;

public class ErrorCodeManager {
    private int codeBase = 5000;
    private int lastCode = -1;
    private Map<Integer, Integer> errorCodes = new HashMap<Integer, Integer>();

    public int generateCode(int hash) {
        int errorCode = 0;
        if (this.errorCodes.containsKey(hash)) {
            return this.errorCodes.get(hash);
        }
        this.lastCode = this.lastCode < 0 ? this.codeBase : ++this.lastCode;
        do {
            errorCode = this.lastCode;
            try {
                this.registerCode(hash, errorCode);
            }
            catch (ErrorCodeAlreadyExistsException ex) {
                errorCode = 0;
                ++this.lastCode;
            }
        } while (errorCode == 0);
        return errorCode;
    }

    public void registerCode(int hash, int errorCode) throws ErrorCodeAlreadyExistsException {
        Integer code = new Integer(errorCode);
        if (this.errorCodes.get(hash) != code) {
            if (this.errorCodes.values().contains(code)) {
                throw new ErrorCodeAlreadyExistsException();
            }
            this.errorCodes.put(hash, code);
        }
    }
}

