/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.mab.extension.IdentifierAlreadyExistsException;
import de.kobv.mable.mab.extension.ReferencesStore;
import de.kobv.mable.mab.extension.ReferencesStoreListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultReferencesStore
implements ReferencesStore {
    private Map<String, Set<String>> satzIdsByType = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> missingIdsByType = new HashMap<String, Set<String>>();
    private Set<ReferencesStoreListener> listeners = new HashSet<ReferencesStoreListener>();
    private String currentDatasetId;
    private static final String NO_TYPE = "NO_TYPE";

    @Override
    public void addDataset(String datasetId, char satzTyp) throws IdentifierAlreadyExistsException {
        String datasetType = Character.toString(satzTyp);
        this.currentDatasetId = datasetId;
        if (this.isIdentifierExists(datasetId)) {
            throw new IdentifierAlreadyExistsException(datasetId);
        }
        Set<String> satzIdsForType = this.satzIdsByType.get(datasetType);
        if (satzIdsForType == null) {
            satzIdsForType = new HashSet<String>();
            this.satzIdsByType.put(datasetType, satzIdsForType);
        }
        satzIdsForType.add(datasetId);
        Set<String> missingIdsForNoType = this.missingIdsByType.get(NO_TYPE);
        Set<String> missingIdsForType = this.missingIdsByType.get(datasetType);
        if (missingIdsForType != null && missingIdsForType.remove(datasetId)) {
            this.fireDatasetFound(datasetId, datasetType);
        } else if (missingIdsForNoType != null && missingIdsForNoType.remove(datasetId)) {
            this.fireDatasetFound(datasetId, datasetType);
        }
    }

    private boolean isIdentifierExists(String identifier) {
        for (Map.Entry<String, Set<String>> entry : this.satzIdsByType.entrySet()) {
            if (!entry.getValue().contains(identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(ReferencesStoreListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Set<String> getMissingDatasets() {
        HashSet<String> allMissingIds = new HashSet<String>();
        for (Set<String> missingIds : this.missingIdsByType.values()) {
            allMissingIds.addAll(missingIds);
        }
        return allMissingIds;
    }

    @Override
    public boolean isDatasetExists(String datasetId) {
        return this.isDatasetExists(datasetId, null);
    }

    @Override
    public boolean isDatasetExists(String datasetId, String datasetType) {
        if (datasetType == null) {
            boolean found = false;
            for (Map.Entry<String, Set<String>> entry : this.satzIdsByType.entrySet()) {
                if (!entry.getValue().contains(datasetId)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.addMissingDataset(datasetId, null);
            }
            return found;
        }
        Set<String> satzIdsForType = this.satzIdsByType.get(datasetType);
        if (satzIdsForType != null && satzIdsForType.contains(datasetId)) {
            return true;
        }
        this.addMissingDataset(datasetId, datasetType);
        return false;
    }

    @Override
    public void removeListener(ReferencesStoreListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getCurrentDataset() {
        return this.currentDatasetId;
    }

    private void fireDatasetFound(String datasetId, String datasetType) {
        for (ReferencesStoreListener listener : this.listeners) {
            listener.datasetFound(datasetId, datasetType);
        }
    }

    private void addMissingDataset(String datasetId, String datasetType) {
        String type = datasetType == null ? NO_TYPE : datasetType;
        Set<String> missingIdsForType = this.missingIdsByType.get(type);
        if (missingIdsForType == null) {
            missingIdsForType = new HashSet<String>();
            this.missingIdsByType.put(type, missingIdsForType);
        }
        missingIdsForType.add(datasetId);
    }
}

