/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab;

import java.util.Arrays;

public final class MabSatzkennung {
    public static final int HEADER_LENGTH = 24;
    public static final char[] DATASET_TYPES = new char[]{'h', 'u', 'y', 'v', 'p', 't', 'k', 'w', 'r', 's', 'x', 'q', 'l', 'e', 'm', 'c'};
    public static final String DATASET_TYPES_STR = "huyvptkwrsxqlemc";
    public static final char[] DATASET_STATUS = new char[]{'c', 'd', 'n', 'p', 'u', 'v'};
    public static final int LENGTH_INDEX = 0;
    public static final int STATUS_INDEX = 5;
    public static final int VERSION_INDEX = 6;
    public static final int INDICATOR_LENGTH_INDEX = 10;
    public static final int SUBFIELD_ID_LENGTH_INDEX = 11;
    public static final int DATA_OFFSET_INDEX = 12;
    public static final int RESERVED_FIELDS_INDEX = 17;
    public static final int TYPE_INDEX = 23;
    public static final String DATASET_STATUS_STR = "cdnpuv";
    private String kennung;

    public MabSatzkennung() {
    }

    public MabSatzkennung(String kennung) {
        this.setValue(kennung);
    }

    public MabSatzkennung(int length, String type, String status) {
        String kennung = MabSatzkennung.constructSatzkennung(length, type, status);
        this.setValue(kennung);
    }

    public String getValue() {
        return this.kennung;
    }

    public void setValue(String header) {
        this.kennung = header;
    }

    public boolean isLengthValid() {
        return Character.isDigit(this.kennung.charAt(0)) && Character.isDigit(this.kennung.charAt(1)) && Character.isDigit(this.kennung.charAt(2)) && Character.isDigit(this.kennung.charAt(3)) && Character.isDigit(this.kennung.charAt(4));
    }

    public char getStatus() {
        return this.kennung.charAt(5);
    }

    public boolean isStatusValid() {
        return DATASET_STATUS_STR.indexOf(this.kennung.charAt(5)) >= 0;
    }

    public boolean isVersionValid() {
        return this.kennung.charAt(6) == 'M' && this.kennung.charAt(7) == '2' && this.kennung.charAt(8) == '.' && this.kennung.charAt(9) == '0';
    }

    public boolean isIndicatorLengthValid() {
        return this.kennung.charAt(10) == '1';
    }

    public boolean isTeilfeldkennungslaengeValid() {
        return this.kennung.charAt(11) == '2';
    }

    public boolean isDataStartAddressValid() {
        return this.kennung.charAt(12) == '0' && this.kennung.charAt(13) == '0' && this.kennung.charAt(14) == '0' && this.kennung.charAt(15) == '2' && this.kennung.charAt(16) == '4';
    }

    public boolean isReservedFieldsEmpty() {
        return this.kennung.charAt(17) == ' ' && this.kennung.charAt(18) == ' ' && this.kennung.charAt(19) == ' ' && this.kennung.charAt(20) == ' ' && this.kennung.charAt(21) == ' ' && this.kennung.charAt(22) == ' ';
    }

    public char getTyp() {
        return this.kennung.charAt(23);
    }

    public boolean isTypeValid() {
        return DATASET_TYPES_STR.indexOf(this.kennung.charAt(23)) >= 0;
    }

    public boolean isValid() {
        return this.isLengthValid() && this.isTypeValid() && this.isStatusValid() && this.isVersionValid() && this.isIndicatorLengthValid() && this.isTeilfeldkennungslaengeValid() && this.isDataStartAddressValid();
    }

    public static String constructSatzkennung(int length, String type, String status) {
        return String.format("%1$05d%2$cM2.01200024      %3$c", length, Character.valueOf(status.charAt(0)), Character.valueOf(type.charAt(0)));
    }

    static {
        Arrays.sort(DATASET_TYPES);
        Arrays.sort(DATASET_STATUS);
    }
}

