/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.IMabSatz;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatzkennung;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MabSatz
implements IMabSatz {
    private String kennung;
    private List<IMabFeld> felder = null;
    private Map<String, List<IMabFeld>> felderByCategory = null;

    public MabSatz(String header) {
        this.kennung = header;
    }

    public MabSatz(String header, List<IMabFeld> fields) {
        this.kennung = header;
        this.felder = fields;
    }

    public MabSatz(MabSatzkennung satzkennung) {
        this.kennung = satzkennung.getValue();
    }

    @Override
    public MabSatzkennung getSatzkennung() {
        return new MabSatzkennung(this.kennung);
    }

    @Override
    public String getId() {
        List<IMabFeld> felder = this.getFelder(MabFeldDefinition.MAB001);
        if (felder != null && felder.size() > 0) {
            return felder.get(0).getInhalt();
        }
        return null;
    }

    @Override
    public void addFeld(IMabFeld feld) {
        this.internAddFeld(feld);
    }

    @Override
    public void removeFeld(IMabFeld feld) {
        this.internRemoveFeld(feld);
    }

    public Set<String> getKategorien() {
        if (this.felderByCategory != null) {
            return this.felderByCategory.keySet();
        }
        return null;
    }

    @Override
    public List<IMabFeld> getFelder() {
        return this.felder;
    }

    @Override
    public List<IMabFeld> getFelder(String category) {
        ArrayList<IMabFeld> felder = new ArrayList<IMabFeld>();
        if (this.felderByCategory != null) {
            for (String key : this.felderByCategory.keySet()) {
                if (!key.startsWith(category)) continue;
                felder.addAll((Collection<IMabFeld>)this.felderByCategory.get(key));
            }
        }
        return felder;
    }

    @Override
    public List<IMabFeld> getFelder(String category, char indikator) {
        List<IMabFeld> felder = null;
        if (this.felderByCategory != null) {
            felder = indikator != '\u0000' ? this.felderByCategory.get(category + indikator) : this.getFelder(category);
        }
        return felder;
    }

    @Override
    public List<IMabFeld> getFelder(MabFeldDefinition feldDef) {
        ArrayList felder = new ArrayList();
        String feldnummer = feldDef.getFeldnummerString();
        return this.getFelder(feldnummer);
    }

    public String getKennung() {
        return this.kennung;
    }

    @Override
    public boolean isFeldPresent(String kategorie) {
        return this.getFelder(kategorie).size() > 0;
    }

    @Override
    public boolean isFeldPresent(String category, char indikator) {
        if (indikator != '\u0000') {
            String name = category + indikator;
            return this.felderByCategory != null && this.felderByCategory.keySet().contains(name);
        }
        return this.isFeldPresent(category);
    }

    public String toString() {
        String satz = this.kennung;
        if (this.felder != null) {
            for (IMabFeld aFelder : this.felder) {
                satz = satz + aFelder.toString();
            }
        }
        satz = satz + Character.toString('\u001d');
        return satz;
    }

    private void internAddFeld(IMabFeld feld) {
        String bezeichner;
        List<IMabFeld> felderForCategory;
        if (this.felder == null) {
            this.felder = new LinkedList<IMabFeld>();
        }
        this.felder.add(feld);
        if (this.felderByCategory == null) {
            this.felderByCategory = new HashMap<String, List<IMabFeld>>();
        }
        if ((felderForCategory = this.felderByCategory.get(bezeichner = feld.getBezeichnung())) == null) {
            felderForCategory = new ArrayList<IMabFeld>();
            this.felderByCategory.put(bezeichner, felderForCategory);
        }
        felderForCategory.add(feld);
    }

    private void internRemoveFeld(IMabFeld feld) {
        if (this.felder == null) {
            return;
        }
        this.felder.remove(feld);
        String bezeichner = feld.getBezeichnung();
        List<IMabFeld> felderForCategory = this.felderByCategory.get(bezeichner);
        if (felderForCategory != null) {
            felderForCategory.remove(feld);
        }
    }
}

