/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.IMabUnterfeld;
import de.kobv.mable.mab.MabException;
import de.kobv.mable.mab.MabFeldDefinition;
import java.util.LinkedList;
import java.util.List;

public final class MabFeld
implements IMabFeld {
    public static final char[] ALL = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' '};
    private String category;
    private char indikator;
    private List<IMabUnterfeld> unterfelder;
    private String inhalt;

    public MabFeld(int number, char indicator) {
        this.category = MabFeldDefinition.getFeldnummerString(number);
        this.indikator = indicator;
        this.setInhalt(null);
        this.setUnterfelder(null);
    }

    public MabFeld(int number, char indicator, String content) {
        this.category = MabFeldDefinition.getFeldnummerString(number);
        this.indikator = indicator;
        this.setInhalt(content);
        this.setUnterfelder(null);
    }

    public MabFeld(int number, char indicator, List<IMabUnterfeld> subfields) {
        this.category = MabFeldDefinition.getFeldnummerString(number);
        this.indikator = indicator;
        this.setInhalt(null);
        this.setUnterfelder(subfields);
    }

    public MabFeld(int number, char indicator, String content, List<IMabUnterfeld> subfields) {
        this.category = MabFeldDefinition.getFeldnummerString(number);
        this.indikator = indicator;
        this.setInhalt(content);
        this.setUnterfelder(subfields);
    }

    public MabFeld(String category, char indikator) throws MabException {
        if (category == null || category.length() != 3) {
            throw new MabException("Parameter category must have a length of 3.");
        }
        this.category = category;
        this.indikator = indikator;
        this.setInhalt(null);
        this.setUnterfelder(null);
    }

    public MabFeld(String category, char indikator, String content) throws MabException {
        if (category == null || category.length() != 3) {
            throw new MabException("Parameter category must have a length of 3.");
        }
        this.category = category;
        this.indikator = indikator;
        this.setInhalt(content);
        this.setUnterfelder(null);
    }

    @Override
    public void addSubfield(IMabUnterfeld unterfeld) {
        if (this.unterfelder == null) {
            this.unterfelder = new LinkedList<IMabUnterfeld>();
        }
        this.unterfelder.add(unterfeld);
    }

    @Override
    public void removeSubfield(IMabUnterfeld unterfeld) {
        if (this.unterfelder != null) {
            this.unterfelder.remove(unterfeld);
        }
    }

    @Override
    public boolean hatUnterfelder() {
        return this.unterfelder != null;
    }

    @Override
    public boolean hatInhalt() {
        return this.inhalt != null && this.inhalt.length() > 0;
    }

    @Override
    public List<IMabUnterfeld> getUnterfelder() {
        return this.unterfelder;
    }

    @Override
    public void setUnterfelder(List<IMabUnterfeld> subfields) {
        this.unterfelder = subfields != null && subfields.size() > 0 ? subfields : null;
    }

    @Override
    public String getInhalt() {
        return this.inhalt;
    }

    @Override
    public void setInhalt(String content) {
        this.inhalt = content;
    }

    @Override
    public int getFeldnummer() {
        try {
            return Integer.parseInt(this.category);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Override
    public int getIndikator() {
        return this.indikator;
    }

    @Override
    public String getBezeichnung() {
        return this.category + Character.toString(this.indikator);
    }

    public String toString() {
        String feld = this.getBezeichnung();
        if (this.hatInhalt()) {
            feld = feld + this.inhalt;
        }
        if (this.hatUnterfelder()) {
            for (IMabUnterfeld anUnterfelder : this.unterfelder) {
                feld = feld + anUnterfelder.toString();
            }
        }
        feld = feld + Character.toString('\u001e');
        return feld;
    }
}

