/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.aleph;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.parser.ContentHandler;
import de.kobv.mable.mab.parser.MabParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AlephSeqParser
implements MabParser {
    private static final Logger LOG = Logger.getLogger(AlephSeqParser.class);
    private ContentHandler contentHandler;
    private State status = State.NONE;

    public void parse(File file) throws FileNotFoundException, IOException, MableConfigurationException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Pattern pattern = Pattern.compile("^(\\d+) (.{4})  L (.*)");
        int datasetCount = 0;
        String datasetId = null;
        this.contentHandler.startParsing();
        this.status = State.IN_DOCUMENT;
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            LOG.debug((Object)matcher.group(0));
            String packageId = matcher.group(1);
            LOG.debug((Object)packageId);
            String feldId = matcher.group(2);
            LOG.debug((Object)feldId);
            String feldValue = matcher.group(3);
            LOG.debug((Object)feldValue);
            if ("LDR ".equals(feldId)) {
                if (this.status == State.IN_SATZ) {
                    this.contentHandler.endSatz();
                }
                ++datasetCount;
                this.status = State.IN_SATZ;
                MabSatzkennung kennung = new MabSatzkennung();
                kennung.setValue(feldValue);
                this.contentHandler.startSatz(kennung);
            } else if ("001 ".equals(feldId)) {
                datasetId = feldValue;
            }
            if (feldValue.contains("$$")) {
                // empty if block
            }
            String feldkennung = feldId.substring(0, 2);
            char indikator = feldId.charAt(3);
            String inhalt = feldValue;
            char unterfeldkennzeichen = ' ';
            String content = null;
            this.contentHandler.startFeld(feldkennung, indikator, inhalt);
            this.contentHandler.startUnterfeld(unterfeldkennzeichen, content);
        }
        if (this.status == State.IN_SATZ) {
            this.contentHandler.endSatz();
        }
        this.contentHandler.endParsing();
    }

    public void parse(InputStream instream) {
    }

    public void parse(Reader reader) {
    }

    @Override
    public void setSource(Reader source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSource(InputStream stream) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse() throws IOException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDatasetsProcessed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDatasetsIgnored() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private static enum State {
        NONE,
        IN_SATZ,
        IN_DOCUMENT;

    }
}

