/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public enum ErrorCode {
    FEHLERHAFTE_LIEFERUNG(1000),
    UNVOLLSTAENDIGE_DATEI(1001),
    ZEICHENSATZ_FEHLER(1002),
    LIEFERUNG_UNVOLLSTAENDIG(1051),
    FELDENDE_OHNE_SATZ(1100),
    NICHTSORTIERBEGINN_OHNE_SATZ(1101),
    NICHTSORTIERENDE_OHNE_SATZ(1102),
    SATZENDE_OHNE_SATZ(1103),
    STICHWORTBEGINN_OHNE_SATZ(1104),
    STICHWORTENDE_OHNE_SATZ(1105),
    TEILFELDTRENNUNG_OHNE_SATZ(1106),
    UNTERFELDBEGINN_OHNE_SATZ(1107),
    EOF_IN_SATZ(2000),
    EOF_IN_SATZKENNUNG(2001),
    SATZLAENGE_UNZULAESSIG(2100),
    SATZSTATUS_UNZULAESSIG(2101),
    VERSIONSANGABE_UNZULAESSIG(2102),
    INDIKATORLAENGE_UNZULAESSIG(2103),
    TEILFELDKENNUNGSLAENGE_UNZULAESSIG(2104),
    DATENANFANGSADRESSE_UNZULAESSIG(2105),
    RESERVIERTEZEICHEN_UNZULAESSIG(2106),
    SATZTYP_UNZULAESSIG(2107),
    FELDENDE_OHNE_FELD(2150),
    NICHTSORTIERBEGINN_OHNE_FELD(2151),
    NICHTSORTIERENDE_OHNE_FELD(2152),
    STICHWORTBEGINN_OHNE_FELD(2153),
    STICHWORTENDE_OHNE_FELD(2154),
    TEILFELDTRENNUNG_OHNE_FELD(2155),
    UNTERFELDBEGINN_OHNE_FELD(2156),
    VERFASSERWERK_OHNE_PERSON(2209),
    URHEBERWERK_OHNE_KOERPERSCHAFT(2210),
    EOF_IN_FELD(3000),
    EOF_IN_FELDNUMMER(3001),
    EOF_IN_FELDINDIKATOR(3002),
    SATZENDE_IN_FELD(3003),
    FELDINHALT_UND_UNTERFELD_VORHANDEN(3004),
    FELDNUMMER_FORMATFEHLER(3100),
    FELDINDIKATOR_FORMATFEHLER(3101),
    FELDNUMMER_INDIKATOR_UNZULAESSIG(3150),
    UNZULAESSIGES_UNTERFELD(3151),
    LEERES_FELD(3152),
    FEHLENDES_UNTERFELD(3153),
    FEHLENDER_NICHTSORTIERBEGINN_IN_FELD(3200),
    FEHLENDER_STICHWORTBEGINN_IN_FELD(3201),
    FEHLENDES_NICHTSORTIERENDE_IN_FELD(3202),
    FEHLENDES_STICHWORTENDE_IN_FELD(3203),
    WIEDERHOLTER_NICHTSORTIERBEGINN_IN_FELD(3204),
    WIEDERHOLTER_STICHWORTBEGINN_IN_FELD(3205),
    EOF_IN_UFELD(4000),
    SATZENDE_IN_UFELD(4001),
    EOF_STATT_UFKENNZEICHEN(4002),
    FELDENDE_STATT_UFKENNZEICHEN(4050),
    NICHTSORTIERBEGINN_STATT_UFKENNZEICHEN(4051),
    NICHTSORTIERENDE_STATT_UFKENNZEICHEN(4052),
    SATZENDE_STATT_UFKENNZEICHEN(4053),
    STICHWORTBEGINN_STATT_UFKENNZEICHEN(4054),
    STICHWORTENDE_STATT_UFKENNZEICHEN(4055),
    TEILFELDTRENNUNG_STATT_UFKENNZEICHEN(4056),
    UNTERFELDBEGINN_STATT_UFKENNZEICHEN(4057),
    UFKENNZEICHEN_FORMATFEHLER(4058),
    FEHLENDER_NICHTSORTIERBEGINN_IN_UFELD(4200),
    FEHLENDER_STICHWORTBEGINN_IN_UFELD(4201),
    FEHLENDES_NICHTSORTIERENDE_IN_UFELD(4202),
    FEHLENDES_STICHWORTENDE_IN_UFELD(4203),
    WIEDERHOLTER_NICHTSORTIERBEGINN_IN_UFELD(4204),
    WIEDERHOLTER_STICHWORTBEGINN_IN_UFELD(4205);

    private static final Map<Integer, ErrorCode> LOOKUP;
    private static final int AUTOMATIC_ERROR_CODE_BASE = 5000;
    private int errorCode;
    private static Properties messages;

    private ErrorCode() {
        this(-1);
    }

    private ErrorCode(int code) {
        this.errorCode = code;
    }

    public int getCode() {
        if (this.errorCode == -1) {
            return 5000 + this.ordinal();
        }
        return this.errorCode;
    }

    public String getMessage() {
        return ErrorCode.getMessages().getProperty(this.name());
    }

    public static ErrorCode get(int errorCode) {
        return LOOKUP.get(errorCode);
    }

    private static Properties getMessages() {
        if (messages == null) {
            messages = new Properties();
            try {
                InputStream in = ErrorCode.class.getClassLoader().getResourceAsStream("de/kobv/mable/error-messages.xml");
                messages.loadFromXML(in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return messages;
    }

    static {
        LOOKUP = new HashMap<Integer, ErrorCode>();
        for (ErrorCode errorCode : EnumSet.allOf(ErrorCode.class)) {
            LOOKUP.put(errorCode.getCode(), errorCode);
        }
    }
}

