/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli.options;

import gov.ornl.sns.cli.ExecutableCommandLineOption;
import org.apache.log4j.Logger;

public final class VersionOption
extends ExecutableCommandLineOption {
    private static final Logger LOG = Logger.getLogger(VersionOption.class);
    private String version;
    private String versionKey;
    private String header;
    private String headerKey;

    public VersionOption() {
        this.setName("v");
        this.setLongName("version");
        this.setDescription("Prints version.");
        this.setStopProcessing(true);
        this.setPriority(40);
        this.setGlobal(true);
    }

    @Override
    public void execute() {
        this.getWriter().println(this.getHeader());
        this.getWriter().println("Version: " + this.getVersion());
    }

    public String getVersion() {
        if (this.version == null && this.versionKey != null && this.getMessages() != null) {
            return this.getMessages().getString(this.versionKey);
        }
        return this.version;
    }

    public void setVersion(String appversion) {
        this.version = appversion;
    }

    public String getHeader() {
        if (this.header == null && this.headerKey != null && this.getMessages() != null) {
            LOG.debug((Object)("Getting header from resources (" + this.headerKey + ")."));
            return this.getMessages().getString(this.headerKey);
        }
        LOG.debug((Object)("Using static configured header (" + this.header + ")."));
        return this.header;
    }

    public void setHeader(String versionheader) {
        this.header = versionheader;
    }

    public String getHeaderKey() {
        return this.headerKey;
    }

    public void setHeaderKey(String key) {
        this.headerKey = key;
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public void setVersionKey(String key) {
        this.versionKey = key;
    }
}

