/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli.options;

import gov.ornl.sns.cli.ExecutableCommandLineOption;
import gov.ornl.sns.cli.MessageResources;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class InfoOption
extends ExecutableCommandLineOption {
    private static final Logger LOG = Logger.getLogger(InfoOption.class);
    private MessageResources bundle;
    private String message;
    private String messageKey;
    private String messageFile;

    public InfoOption() {
        this.setName("i");
        this.setLongName("info");
        this.setStopProcessing(true);
        this.setPriority(50);
        this.setGlobal(true);
    }

    @Override
    public void execute() throws Exception {
        InputStream in = null;
        if (this.messageFile != null) {
            in = this.getClass().getClassLoader().getResourceAsStream(this.messageFile);
        }
        if (in != null) {
            String line;
            BufferedReader rin = new BufferedReader(new InputStreamReader(in));
            while ((line = rin.readLine()) != null) {
                this.getWriter().println(line);
            }
        } else if (this.bundle != null && this.messageKey != null) {
            this.getWriter().println(this.bundle.getString(this.messageKey));
        } else if (this.message != null) {
            this.getWriter().println(this.message);
        } else {
            LOG.error((Object)"no message configured");
        }
    }

    public final MessageResources getBundle() {
        return this.bundle;
    }

    public final void setBundle(MessageResources resources) {
        this.bundle = resources;
    }

    public final String getMessageKey() {
        return this.messageKey;
    }

    public final void setMessageKey(String key) {
        this.messageKey = key;
    }

    public final String getMessage() {
        if (this.message == null && this.bundle != null && this.messageKey != null) {
            return this.bundle.getString(this.messageKey);
        }
        return this.message;
    }

    public final void setMessage(String msg) {
        this.message = msg;
    }

    public final String getMessageFile() {
        return this.messageFile;
    }

    public final void setMessageFile(String msgFile) {
        this.messageFile = msgFile;
    }
}

