/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli.options;

import gov.ornl.sns.cli.CommandLineOption;
import gov.ornl.sns.cli.CommandLineProcessor;
import gov.ornl.sns.cli.CommandLineProcessorAware;
import gov.ornl.sns.cli.DefaultSubCommand;
import gov.ornl.sns.cli.ExecutableCommandLineOption;
import gov.ornl.sns.cli.SubCommand;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HelpOption
extends ExecutableCommandLineOption
implements CommandLineProcessorAware {
    private static final Logger LOG = Logger.getLogger(HelpOption.class);
    private static final int DEFAULT_OUTPUT_WIDTH = 80;
    private static final int DEFAULT_DESCRIPTION_PADDING = 3;
    private String syntax = null;
    private String header = null;
    private String headerKey;
    private String footer = null;
    private String footerKey;
    private boolean autoUsage = true;
    private CommandLineProcessor commandLine;
    private int width = 80;
    private int optionsIndent = 1;
    private int descriptionPadding = 3;
    private String appName = "<appName not configured>";
    private String usage;

    public HelpOption() {
        this.setName("h");
        this.setLongName("help");
        this.setDescription("Print help message.");
        this.setStopProcessing(true);
        this.setPriority(30);
        this.setAutoUsage(false);
        this.setGlobal(true);
    }

    @Override
    public void execute() throws MissingArgumentException {
        LOG.debug((Object)"Execute HelpOption");
        CommandLineProcessor clp = this.getCommandLineProcessor();
        if (clp.isSubcommandsPresent()) {
            String commandName = clp.getSubCommandName();
            if (commandName == null) {
                this.printHelp(true);
            } else {
                this.printSubcommandHelp();
            }
        } else {
            this.printHelp(false);
        }
    }

    public void printHelpUsage() {
        this.getWriter().println("Type '" + this.appName + " --" + this.getLongName() + "' for usage.");
    }

    public final String getHeader() {
        if (StringUtils.isEmpty((String)this.header) && this.headerKey != null && this.getMessages() != null) {
            return this.getMessages().getString(this.headerKey);
        }
        return this.header;
    }

    public final void setHeader(String helpheader) {
        this.header = helpheader;
    }

    public final String getHeaderKey() {
        return this.headerKey;
    }

    public final void setHeaderKey(String key) {
        this.headerKey = key;
    }

    public final String getFooter() {
        if (StringUtils.isEmpty((String)this.footer) && this.footerKey != null && this.getMessages() != null) {
            return this.getMessages().getString(this.footerKey);
        }
        return this.footer;
    }

    public final void setFooter(String helpfooter) {
        this.footer = helpfooter;
    }

    public final String getFooterKey() {
        return this.footerKey;
    }

    public final void setFooterKey(String key) {
        this.footerKey = key;
    }

    public final String getSyntax() {
        return this.syntax;
    }

    public final void setSyntax(String appsyntax) {
        this.syntax = appsyntax;
    }

    public final boolean isAutoUsage() {
        return this.autoUsage;
    }

    public final void setAutoUsage(boolean autoUsageEnabled) {
        this.autoUsage = autoUsageEnabled;
    }

    public final String getAppName() {
        return this.appName;
    }

    public final void setAppName(String appname) {
        this.appName = appname;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final void setUsage(String helpusage) {
        this.usage = helpusage;
    }

    public final CommandLineProcessor getCommandLineProcessor() {
        return this.commandLine;
    }

    @Override
    public final void setCommandLineProcessor(CommandLineProcessor cmdLine) {
        this.commandLine = cmdLine;
    }

    protected void printHelp(boolean printSubcommands) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter writer = new PrintWriter((Writer)this.getWriter(), true);
        Options options = this.commandLine.getCommonsCliOptions(printSubcommands);
        String cliSyntax = this.getCommandLineSyntax();
        if (this.autoUsage) {
            formatter.printUsage(writer, this.width, cliSyntax, options);
        } else {
            formatter.printUsage(writer, this.width, cliSyntax);
        }
        if (this.getHeader() != null) {
            writer.println();
            this.printText(writer, this.getHeader());
        }
        writer.println();
        if (printSubcommands) {
            writer.println("Global Options:");
        } else {
            writer.println("Options:");
        }
        formatter.printOptions(writer, this.width, options, this.optionsIndent, this.descriptionPadding);
        if (printSubcommands) {
            this.printSubcommandList(this.getWriter());
        }
        if (this.getFooter() != null) {
            writer.println();
            this.printText(writer, this.getFooter());
        }
    }

    protected void printSubcommandList(PrintWriter out) {
        out.println();
        out.println("Available subcommands:");
        Set<SubCommand> commands = this.commandLine.getSubCommands();
        Iterator<SubCommand> commandIter = commands.iterator();
        int columnSize = 1;
        while (commandIter.hasNext()) {
            SubCommand command = commandIter.next();
            int commandLength = command.getName().length();
            if (columnSize >= commandLength) continue;
            columnSize = commandLength + 1;
        }
        for (SubCommand command : commands) {
            out.format("  %1$-" + columnSize + "s %2$s %n", command.getName(), command.getDescription());
        }
    }

    protected void printSubcommandHelp() throws MissingArgumentException {
        Set<CommandLineOption> options;
        String commandName;
        CommandLineProcessor clp = this.getCommandLineProcessor();
        DefaultSubCommand command = (DefaultSubCommand)clp.getCommand(commandName = clp.getSubCommandName());
        if (command == null) {
            throw new MissingArgumentException("Unknown subcommand found.");
        }
        PrintWriter writer = new PrintWriter((Writer)this.getWriter(), true);
        writer.println(commandName + ": " + command.getDescription());
        writer.println("usage: " + commandName + " " + command.getUsage());
        writer.println();
        HelpFormatter formatter = new HelpFormatter();
        String help = command.getHelp();
        if (help != null) {
            this.printText(writer, help);
            writer.println();
        }
        if ((options = command.getOptions()) != null) {
            formatter.printHelp(commandName + " [options]", null, clp.getCommonsCliOptions(options), null);
            writer.println();
        }
        writer.println("Global options:");
        formatter.printOptions(writer, 80, clp.getCommonsCliOptions(true), 1, 3);
    }

    protected String getCommandLineSyntax() {
        String cliSyntax = this.getSyntax();
        if (StringUtils.isBlank((String)cliSyntax)) {
            cliSyntax = this.getAppName() + " " + this.getUsage();
        }
        return cliSyntax;
    }

    protected void printText(PrintWriter writer, String text) {
        HelpFormatter formatter = new HelpFormatter();
        Pattern pattern = Pattern.compile("^\\s*$", 8);
        String[] paragraphs = pattern.split(text.trim());
        for (int i = 0; i < paragraphs.length; ++i) {
            String paragraph = paragraphs[i].trim();
            if (paragraph.length() <= 0) continue;
            formatter.printWrapped(writer, this.width, paragraph);
            if (i >= paragraphs.length - 1) continue;
            writer.println();
        }
    }
}

