/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli.options;

import gov.ornl.sns.cli.ExecutableCommandLineOption;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class DebugOption
extends ExecutableCommandLineOption {
    private String loggerName = "gov.ornl.sns";
    private List<String> loggerNames;
    private Level logLevel = Level.DEBUG;
    private boolean printDebugOutputEnabled = false;

    public DebugOption() {
        this.setName("d");
        this.setLongName("debug");
        this.setDescription("Enables debug output.");
        this.setPriority(10);
        this.setGlobal(true);
    }

    @Override
    public void execute() {
        this.getWriter().println("Debug output enabled");
        if (this.loggerNames != null) {
            for (String logger : this.loggerNames) {
                this.setLoggerLevel(logger, this.logLevel);
            }
        } else {
            this.setLoggerLevel(this.loggerName, this.logLevel);
        }
    }

    protected void setLoggerLevel(String logger, Level level) {
        if (StringUtils.isEmpty((String)logger)) {
            if (this.printDebugOutputEnabled) {
                this.getWriter().println("Set root logger to " + level.toString());
            }
            Logger.getRootLogger().setLevel(level);
        } else {
            if (this.printDebugOutputEnabled) {
                this.getWriter().println("Set logger " + logger + " to " + level.toString());
            }
            Logger.getLogger((String)logger).setLevel(level);
        }
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggername) {
        this.loggerName = loggername;
    }

    public String getLogLevel() {
        return this.logLevel.toString();
    }

    public void setLogLevel(String level) {
        if (!StringUtils.isBlank((String)level)) {
            this.logLevel = Level.toLevel((String)level);
        }
    }

    public List<String> getLoggerNames() {
        return this.loggerNames;
    }

    public void setLoggerNames(List<String> loggernames) {
        this.loggerNames = loggernames;
    }

    public boolean isPrintDebugOutputEnabled() {
        return this.printDebugOutputEnabled;
    }

    public void setPrintDebugOutputEnabled(boolean debugOutputEnabled) {
        this.printDebugOutputEnabled = debugOutputEnabled;
    }
}

