/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli;

import gov.ornl.sns.cli.InvalidOptionException;
import gov.ornl.sns.cli.MessageResources;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SubCommand
implements Comparable<SubCommand> {
    private String name;
    private String description;
    private String descriptionKey;
    private String usage;
    private String help;
    private String helpKey;
    private MessageResources messages;

    public abstract void execute();

    public abstract void prepare() throws MissingOptionException, InvalidOptionException, MissingArgumentException;

    public final String getName() {
        return this.name;
    }

    public final void setName(String cmdname) {
        this.name = cmdname;
    }

    public final String getDescription() {
        if (this.description == null && this.messages != null && this.descriptionKey != null) {
            return this.messages.getString(this.descriptionKey);
        }
        return this.description;
    }

    public final void setDescription(String descr) {
        this.description = descr;
    }

    public final String getDescriptionKey() {
        return this.descriptionKey;
    }

    public final void setDescriptionKey(String key) {
        this.descriptionKey = key;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final void setUsage(String cmdusage) {
        this.usage = cmdusage;
    }

    public final String getHelp() {
        if (this.help == null && this.messages != null && this.helpKey != null) {
            return this.messages.getString(this.helpKey);
        }
        return this.help;
    }

    public final void setHelp(String cmdhelp) {
        this.help = cmdhelp;
    }

    public final String getHelpKey() {
        return this.helpKey;
    }

    public final void setHelpKey(String key) {
        this.helpKey = key;
    }

    public final MessageResources getMessages() {
        return this.messages;
    }

    @Autowired
    public final void setMessages(MessageResources resources) {
        this.messages = resources;
    }

    @Override
    public final int compareTo(SubCommand o) {
        String oname = o.getName();
        return this.getName().compareTo(oname);
    }
}

