/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli;

import gov.ornl.sns.cli.CommandLineOption;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.log4j.Logger;

public final class OptionHelper {
    private static final Logger LOG = Logger.getLogger(OptionHelper.class);
    private CommandLine commandLine;

    public OptionHelper(CommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException("Parameter 'commandLine' cannot be NULL.");
        }
        this.commandLine = commandLine;
    }

    public void processOptions(Object bean, Set<CommandLineOption> options) throws MissingOptionException {
        LOG.debug((Object)("Processing options for " + bean));
        if (options == null) {
            return;
        }
        for (CommandLineOption option : options) {
            this.processOption(bean, option);
        }
    }

    protected void processOption(Object bean, CommandLineOption option) throws MissingOptionException {
        Object value = this.getValue(option);
        if (option.isRequired() && value == null) {
            throw new MissingOptionException("Option " + option.getLongName() + "(-" + option.getName() + ") is required.");
        }
        if (value != null) {
            try {
                String propertyName = option.getPropertyName();
                BeanUtils.setProperty((Object)bean, (String)propertyName, (Object)value);
                LOG.debug((Object)("Set property " + option.getLongName() + " to " + value));
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)"Error setting bean property", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)"Error setting bean property", (Throwable)e);
            }
        }
    }

    protected Object getValue(CommandLineOption option) {
        String optionName = option.getLongName();
        switch (option.getArguments()) {
            case 0: {
                return this.commandLine.hasOption(optionName);
            }
            case 1: {
                return this.commandLine.getOptionValue(optionName);
            }
        }
        return this.commandLine.getOptionValues(optionName);
    }
}

