/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli;

import gov.ornl.sns.cli.CommandLineAware;
import gov.ornl.sns.cli.CommandLineHandler;
import gov.ornl.sns.cli.CommandLineOption;
import gov.ornl.sns.cli.CommandLineProcessorAware;
import gov.ornl.sns.cli.ConfigurationException;
import gov.ornl.sns.cli.ExecutableCommandLineOption;
import gov.ornl.sns.cli.ExecutableCommandLineOptionComparator;
import gov.ornl.sns.cli.InvalidOptionException;
import gov.ornl.sns.cli.MessageResources;
import gov.ornl.sns.cli.OptionHelper;
import gov.ornl.sns.cli.SubCommand;
import gov.ornl.sns.cli.UnknownSubcommandException;
import gov.ornl.sns.cli.options.HelpOption;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public final class CommandLineProcessor
implements ApplicationContextAware {
    private static final Logger LOG = Logger.getLogger(CommandLineProcessor.class);
    private ApplicationContext applicationContext;
    private Map<String, SubCommand> commands = new HashMap<String, SubCommand>();
    private Map<String, CommandLineOption> options = new HashMap<String, CommandLineOption>();
    private SortedSet<ExecutableCommandLineOption> executableOptions = new TreeSet<ExecutableCommandLineOption>(new ExecutableCommandLineOptionComparator());
    private String commandName;
    private int errorCode;
    private CommandLineHandler handler;
    private boolean requireArguments = false;
    private HelpOption helpOption;
    private MessageResources bundle;
    private String header;
    private String headerKey;
    private PrintWriter out;
    private boolean quietMode;

    public void init() throws ConfigurationException {
        if (this.applicationContext == null) {
            LOG.error((Object)"applicationContext has not been set");
            return;
        }
        this.findOptions();
        this.findCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processArguments(String[] args) {
        LOG.debug((Object)"Processing arguments");
        Options cliOptions = this.getCommonsCliOptions();
        try {
            BasicParser parser = new BasicParser();
            CommandLine commandLine = parser.parse(cliOptions, args);
            this.commandName = this.getSubCommandName(commandLine);
            if (!this.handleExecutableOptions(commandLine)) {
                this.printHeader();
                if (this.commands.isEmpty()) {
                    if (this.handler != null) {
                        OptionHelper optionHelper = new OptionHelper(commandLine);
                        optionHelper.processOptions(this.handler, new HashSet<CommandLineOption>(this.options.values()));
                        if (args.length > 0 || !this.requireArguments) {
                            this.handler.prepare();
                            this.handler.execute();
                        } else {
                            LOG.debug((Object)"no arguments provided, but required");
                            if (this.helpOption != null) {
                                this.helpOption.printHelpUsage();
                            }
                        }
                    } else {
                        LOG.error((Object)"no handler configured");
                        System.err.println("cli error: no handler found");
                    }
                } else {
                    this.handleSubCommands(commandLine);
                }
            }
        }
        catch (MissingArgumentException e) {
            System.err.println(e.getMessage());
            this.setErrorCode(-1);
        }
        catch (MissingOptionException e) {
            System.err.println(e.getMessage());
            this.setErrorCode(-1);
        }
        catch (InvalidOptionException e) {
            System.err.println(e.getMessage());
            this.setErrorCode(-1);
        }
        catch (Throwable e) {
            System.err.println("While parsing options: " + e);
            e.printStackTrace(this.out);
            this.setErrorCode(-1);
        }
        finally {
            if (this.getErrorCode() == -1 && this.helpOption != null) {
                this.helpOption.printHelpUsage();
            }
        }
    }

    private void printHeader() {
        if (!this.quietMode) {
            if (this.header != null) {
                this.out.println(StringUtils.strip((String)this.header));
                this.out.println();
            } else if (this.bundle != null && this.headerKey != null) {
                this.out.println(StringUtils.strip((String)this.bundle.getString(this.headerKey)));
                this.out.println();
            }
        }
    }

    protected boolean handleExecutableOptions(CommandLine commandLine) throws Exception {
        LOG.debug((Object)"handle executable options");
        for (ExecutableCommandLineOption option : this.executableOptions) {
            LOG.debug((Object)("check if option: " + option));
            if (!commandLine.hasOption(option.getName())) continue;
            LOG.debug((Object)("execute option: " + option));
            if (option instanceof CommandLineProcessorAware) {
                ((CommandLineProcessorAware)((Object)option)).setCommandLineProcessor(this);
            }
            if (option.isStopProcessing()) {
                this.printHeader();
            }
            option.execute();
            if (!option.isStopProcessing()) continue;
            return true;
        }
        return false;
    }

    protected void handleSubCommands(CommandLine commandLine) throws MissingOptionException, MissingArgumentException, InvalidOptionException {
        LOG.debug((Object)"handle sub commands");
        String cmdName = this.getSubCommandName(commandLine);
        if (cmdName == null) {
            throw new MissingArgumentException("No subcommand found.");
        }
        SubCommand command = this.commands.get(cmdName);
        if (command != null) {
            if (command instanceof CommandLineAware) {
                ((CommandLineAware)((Object)command)).setCommandLine(commandLine);
            }
        } else {
            throw new UnknownSubcommandException("Invalid subcommand '" + cmdName + "' found.");
        }
        OptionHelper optionHelper = new OptionHelper(commandLine);
        Set<CommandLineOption> globalOptions = this.getGlobalOptions();
        optionHelper.processOptions(command, globalOptions);
        command.prepare();
        command.execute();
    }

    public SubCommand getCommand(String cmdname) {
        return this.commands.get(cmdname);
    }

    public Set<SubCommand> getSubCommands() {
        return new TreeSet<SubCommand>(this.commands.values());
    }

    public String getSubCommandName() {
        return this.commandName;
    }

    public boolean isSubcommandsPresent() {
        return !this.commands.isEmpty();
    }

    protected void findOptions() throws ConfigurationException {
        Map optionBeanMap = this.applicationContext.getBeansOfType(CommandLineOption.class);
        Collection optionBeans = optionBeanMap.values();
        HashSet<String> longNames = new HashSet<String>();
        for (CommandLineOption optionBean : optionBeans) {
            String name = optionBean.getName();
            String longName = optionBean.getLongName();
            if (this.options.containsKey(name) || longNames.contains(longName)) {
                throw new ConfigurationException("Duplicate option configured [" + name + ", " + longName + "]");
            }
            this.options.put(optionBean.getName(), optionBean);
            longNames.add(longName);
            if (!(optionBean instanceof ExecutableCommandLineOption)) continue;
            this.addExecutableOption((ExecutableCommandLineOption)optionBean);
            if (!(optionBean instanceof HelpOption)) continue;
            this.helpOption = (HelpOption)optionBean;
        }
    }

    protected void findCommands() throws ConfigurationException {
        Map commandBeanMap = this.applicationContext.getBeansOfType(SubCommand.class);
        Collection commandBeans = commandBeanMap.values();
        for (SubCommand commandBean : commandBeans) {
            String name = commandBean.getName();
            if (!this.commands.containsKey(name)) {
                this.commands.put(commandBean.getName(), commandBean);
                continue;
            }
            throw new ConfigurationException("Duplicate subcommand configured [" + name + "]");
        }
    }

    protected String getSubCommandName(CommandLine commandLine) {
        String[] commandNames = commandLine.getArgs();
        String command = null;
        if (commandNames.length >= 1) {
            command = commandNames[0];
        }
        return command;
    }

    public Options getCommonsCliOptions() {
        return this.getCommonsCliOptions(new HashSet<CommandLineOption>(this.options.values()));
    }

    public Options getCommonsCliOptions(boolean onlyGlobal) {
        return this.getCommonsCliOptions(new HashSet<CommandLineOption>(this.options.values()), onlyGlobal);
    }

    public Options getCommonsCliOptions(Set<CommandLineOption> optionsSet) {
        return this.getCommonsCliOptions(optionsSet, false);
    }

    public Options getCommonsCliOptions(Set<CommandLineOption> optionsSet, boolean onlyGlobal) {
        Options cliOptions = new Options();
        for (CommandLineOption option : optionsSet) {
            if (onlyGlobal && !option.isGlobal()) continue;
            Option cliOption = this.createOption(option);
            cliOptions.addOption(cliOption);
        }
        return cliOptions;
    }

    public Set<CommandLineOption> getGlobalOptions() {
        HashSet<CommandLineOption> result = new HashSet<CommandLineOption>();
        for (CommandLineOption option : this.options.values()) {
            if (option instanceof ExecutableCommandLineOption && ((ExecutableCommandLineOption)option).isStopProcessing() || !option.isGlobal()) continue;
            result.add(option);
        }
        return result;
    }

    protected Option createOption(CommandLineOption option) {
        Option cliOption;
        String description = option.getDescription();
        String descriptionKey = option.getDescriptionKey();
        if (description == null && descriptionKey != null) {
            description = this.bundle.getString(descriptionKey);
        }
        switch (option.getArguments()) {
            case 0: {
                cliOption = new Option(option.getName(), description);
                break;
            }
            case 1: {
                cliOption = new Option(option.getName(), true, description);
                cliOption.setArgName(option.getArgName());
                break;
            }
            default: {
                OptionBuilder.withDescription((String)description);
                OptionBuilder.hasArgs();
                cliOption = OptionBuilder.create((String)option.getName());
                cliOption.setArgName(option.getArgName());
                cliOption.setValueSeparator(option.getValueSeparator());
            }
        }
        if (!StringUtils.isBlank((String)option.getLongName())) {
            cliOption.setLongOpt(option.getLongName());
        }
        return cliOption;
    }

    protected void addExecutableOption(ExecutableCommandLineOption option) {
        LOG.debug((Object)("Add executable option: " + option));
        this.executableOptions.add(option);
    }

    public SortedSet<ExecutableCommandLineOption> getExecutableOptions() {
        return this.executableOptions;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public CommandLineHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CommandLineHandler clhandler) {
        this.handler = clhandler;
    }

    public boolean isRequireArguments() {
        return this.requireArguments;
    }

    public void setRequireArguments(boolean requireArgs) {
        this.requireArguments = requireArgs;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errCode) {
        this.errorCode = errCode;
    }

    public MessageResources getBundle() {
        return this.bundle;
    }

    @Autowired
    public void setBundle(MessageResources resources) {
        this.bundle = resources;
    }

    public String getHeader() {
        if (this.header == null && this.headerKey != null && this.bundle != null) {
            return this.bundle.getString(this.headerKey);
        }
        return this.header;
    }

    public void setHeader(String headerStr) {
        this.header = headerStr;
    }

    public String getHeaderKey() {
        return this.headerKey;
    }

    public void setHeaderKey(String key) {
        this.headerKey = key;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    @Autowired(required=true)
    public void setWriter(PrintWriter writer) {
        this.out = writer;
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }
}

