/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli;

import gov.ornl.sns.cli.CommandLineProcessor;
import org.apache.log4j.Logger;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class CommandLineHelper {
    private static final Logger LOG = Logger.getLogger(CommandLineHelper.class);
    private String[] springConfigFiles;
    private String commandLineProcessorBeanName = "commandLineProcessor";

    public CommandLineHelper(String configFile) {
        this.springConfigFiles = new String[]{configFile};
    }

    public CommandLineHelper(String[] configFiles) {
        this.springConfigFiles = configFiles;
    }

    public ConfigurableApplicationContext loadContext() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(this.springConfigFiles);
        context.registerShutdownHook();
        return context;
    }

    public void run(String[] args) {
        ConfigurableApplicationContext context = this.loadContext();
        CommandLineProcessor processor = (CommandLineProcessor)context.getBean(this.commandLineProcessorBeanName);
        processor.processArguments(args);
        context.close();
    }
}

