/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.sns.cli;

import gov.ornl.sns.cli.Argument;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.log4j.Logger;

public class ArgumentHelper {
    private static final Logger LOG = Logger.getLogger(ArgumentHelper.class);

    public void process(Object bean, CommandLine commandLine, List<Argument> arguments) throws MissingArgumentException {
        String[] args = commandLine.getArgs();
        LOG.debug((Object)("Arguments: " + Arrays.asList(args)));
        int index = 1;
        if (args.length <= arguments.size()) {
            throw new MissingArgumentException("Argument is missing.");
        }
        for (Argument argument : arguments) {
            String value = args[index];
            String propertyName = argument.getPropertyName();
            try {
                BeanUtils.setProperty((Object)bean, (String)propertyName, (Object)value);
            }
            catch (IllegalAccessException iae) {
                LOG.error((Object)"Error setting argument value.", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                LOG.error((Object)"Error setting argument value.", (Throwable)ite);
            }
            ++index;
        }
    }
}

