/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab.extension.IErrorStatistics;
import de.kobv.mable.mab2.modules.AbstractMableModule2;
import de.kobv.mable.mab2.modules.BadExtraFieldErrorType;
import de.kobv.mable.mab2.modules.FieldCountErrorType;
import de.kobv.mable.mab2.modules.RequiredCategoryErrorType;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Wiederholfaktoren
extends AbstractMableModule2 {
    private IErrorStatistics errorStatistics;
    private Set<ErrorType> errorTypes;

    @Override
    public void process(MabSatz satz) {
        Set kategorien = satz.getKategorien();
        if (kategorien == null) {
            this.verifyRequiredFields(satz);
        } else {
            this.verifyRequiredFields(satz);
            this.verifyExistingFields(satz, kategorien);
        }
    }

    public void setErrorStatistics(IErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public void setErrorTypes(Set<ErrorType> errorTypes) {
        this.errorTypes = errorTypes;
    }

    protected void verifyRequiredFields(MabSatz satz) {
        MabSatzkennung satzkennung = satz.getSatzkennung();
        String satztyp = Character.toString(satzkennung.getTyp());
        for (MabFeldDefinition feldDef : EnumSet.allOf(MabFeldDefinition.class)) {
            if (!feldDef.isRequiredForSatztyp(satztyp) || satz.isFeldPresent(feldDef.getFeldnummerString())) continue;
            RequiredCategoryErrorType errorType = new RequiredCategoryErrorType(feldDef.getFeldnummerString(), satztyp);
            this.errorStatistics.addError(new DatasetError((ErrorType)errorType, satz.getId()));
        }
    }

    protected void verifyExistingFields(MabSatz satz, Set<String> kategorien) {
        for (String kategorie : kategorien) {
            int feldnummer = 0;
            try {
                feldnummer = Integer.parseInt(kategorie.substring(0, 3));
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            MabFeldDefinition feldDef = MabFeldDefinition.getFeld((int)feldnummer);
            if (feldDef == null) continue;
            List felder = satz.getFelder(feldDef);
            int wiederholfaktor = feldDef.getWiederholfaktor();
            if (felder == null || felder.size() <= 0) continue;
            if (feldDef.isIndikatorWiederholbar()) {
                if (felder.size() > wiederholfaktor && wiederholfaktor != 0) {
                    this.errorStatistics.addError(new DatasetError((ErrorType)new FieldCountErrorType(feldDef.getFeldnummerString()), satz.getId()));
                }
            } else {
                char[] indikatoren = feldDef.getIndikatoren();
                for (int i = 0; i < indikatoren.length; ++i) {
                    List felderMitIndikator = satz.getFelder(feldDef.getFeldnummerString(), indikatoren[i]);
                    if (felderMitIndikator == null || felderMitIndikator.size() <= 1) continue;
                    this.errorStatistics.addError(new DatasetError((ErrorType)new FieldCountErrorType(feldDef.getFeldnummerString(), Character.toString(indikatoren[i])), satz.getId()));
                }
            }
            Set satztypen = feldDef.getSatztypen();
            String satztyp = Character.toString(satz.getSatzkennung().getTyp());
            if (satztypen == null || satztypen.contains(satztyp)) continue;
            this.errorStatistics.addError(new DatasetError((ErrorType)new BadExtraFieldErrorType(satztyp, feldDef.getFeldnummerString()), satz.getId()));
        }
    }
}

