/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.IMabSatz;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab2.modules.AbstractMabCheck;
import de.kobv.mable.mab2.modules.IsbnError;
import de.kobv.mable.mab2.modules.IsbnErrorType;
import de.kobv.mable.mab2.modules.IsbnStatistics;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.ISBNValidator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidateIsbn
extends AbstractMabCheck {
    private static final Logger LOG = Logger.getLogger(ValidateIsbn.class);
    private ISBNValidator validator = ISBNValidator.getInstance();
    private Pattern isbnPattern = Pattern.compile("ISBN (\\S+).?");
    private Pattern withoutIsbnPattern = Pattern.compile("(\\S+).?");
    private IsbnStatistics statistics;

    @Override
    public void process(MabSatz satz) {
        List felder = satz.getFelder(MabFeldDefinition.MAB540);
        for (IMabFeld feld : felder) {
            this.checkField((IMabSatz)satz, feld);
        }
    }

    public void checkField(IMabSatz satz, IMabFeld feld) {
        String content = feld.getInhalt();
        String indicator = Character.toString((char)feld.getIndikator());
        boolean isbnValid = this.isValid(content);
        switch (indicator.charAt(0)) {
            case 'a': {
                if (isbnValid) break;
                Set<IsbnErrorType.Reason> reasons = this.analyseInvalidIsbn(content);
                this.addDatasetError(new IsbnErrorType("INVALID_ISBN_IN_540A", reasons), satz, content);
                this.statistics.addInvalidIsbnReasons(reasons);
                break;
            }
            case 'b': {
                if (!isbnValid) break;
                this.addDatasetError(new IsbnErrorType("VALID_ISBN_IN_540B"), satz, content);
                break;
            }
            case 'z': {
                if (!content.contains("ISBN")) break;
                this.addDatasetError(new IsbnErrorType("ISBN_IN_540Z"), satz, content);
                break;
            }
        }
    }

    public Set<IsbnErrorType.Reason> analyseInvalidIsbn(String content) {
        HashSet<IsbnErrorType.Reason> reason = new HashSet<IsbnErrorType.Reason>();
        if (this.isIsbnMissing(content)) {
            reason.add(IsbnErrorType.Reason.ISBN_WITHOUT_LEADER);
        } else {
            if (this.isValid(content, true)) {
                reason.add(IsbnErrorType.Reason.ISBN_BAD_FORMAT);
            }
            if (this.isSmallX(content)) {
                reason.add(IsbnErrorType.Reason.ISBN_SMALL_X);
            }
        }
        return reason;
    }

    protected void addDatasetError(IsbnErrorType errorType, IMabSatz satz, String content) {
        this.getErrorStatistics().addError((DatasetError)new IsbnError(satz, errorType, content));
    }

    protected boolean isIsbnMissing(String content) {
        return !content.startsWith("ISBN ");
    }

    protected boolean isSmallX(String content) {
        return this.isValid(content.toUpperCase());
    }

    public String prepareValue(String content) {
        Matcher matcher = this.isbnPattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public boolean isValid(String isbn) {
        return this.isValid(isbn, false);
    }

    public boolean isContainsMultipleISBN(String content) {
        String value = this.prepareValue(content);
        if (value == null) {
            return false;
        }
        int digits = 0;
        for (int pos = 0; pos < value.length(); ++pos) {
            char charAt = value.charAt(pos);
            if (!Character.isDigit(charAt) && charAt != 'x' && charAt != 'X') continue;
            ++digits;
        }
        return digits >= 20;
    }

    protected boolean isValid(String isbn, boolean removeSeparator) {
        String value = this.prepareValue(isbn);
        if (removeSeparator) {
            value = StringUtils.remove((String)value, (String)"-");
        }
        LOG.debug((Object)("isValid(" + value + ")"));
        return this.validator.isValid(value);
    }

    @Autowired
    public void setIsbnStatistics(IsbnStatistics statistics) {
        this.statistics = statistics;
    }
}

