/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab2.modules.AbstractMabCheck;
import de.kobv.mable.mab2.modules.RequiredCategoryErrorType;
import org.apache.log4j.Logger;

public class RequiredCategory
extends AbstractMabCheck {
    private static final Logger LOG = Logger.getLogger(RequiredCategory.class);

    @Override
    public void process(MabSatz satz) {
        char satztyp = this.getSatzTyp();
        if (!(satztyp != '\u0000' && satztyp != satz.getSatzkennung().getTyp() || satz.isFeldPresent(this.getKategorie(), this.getIndikator()))) {
            LOG.debug((Object)("Checking Satz '" + satz.getId() + "' for category '" + this.getKategorie() + "'."));
            DatasetError error = this.getError(satz);
            this.getErrorStatistics().addError(this.getError(satz));
        }
    }

    private DatasetError getError(MabSatz satz) {
        String satzTyp = null;
        if (this.getSatzTyp() != '\u0000') {
            satzTyp = Character.toString(this.getSatzTyp());
        }
        DatasetError error = new DatasetError((ErrorType)new RequiredCategoryErrorType(this.getKategorie(), satzTyp, this.getErrorMessageKey(), this.getErrorCode()), satz.getId());
        return error;
    }

    public String toString() {
        return super.toString() + "[" + this.getKategorie() + "]";
    }
}

