/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab.extension.ReferencesStore;
import de.kobv.mable.mab.extension.ReferencesStoreListener;
import de.kobv.mable.mab2.modules.AbstractMabCheck;
import de.kobv.mable.mab2.modules.ReferenceErrorType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class Reference
extends AbstractMabCheck
implements ReferencesStoreListener {
    private Map<String, Set<String>> missingSatzIds = new HashMap<String, Set<String>>();
    private String targetDatasetType = null;
    private ReferencesStore referencesStore;

    @Override
    public void process(MabSatz satz) {
        if (this.getSatzTyp() == '\u0000' || this.getSatzTyp() == satz.getSatzkennung().getTyp()) {
            List felder = satz.getFelder(this.getKategorie(), this.getIndikator());
            for (IMabFeld feld : felder) {
                this.checkField(satz.getId(), feld);
            }
        }
    }

    protected void checkField(String satzId, IMabFeld feld) {
        String referenceId = feld.getInhalt();
        if (!this.referencesStore.isDatasetExists(referenceId, this.targetDatasetType)) {
            Set<String> saetze = this.missingSatzIds.get(referenceId);
            if (saetze == null) {
                saetze = new HashSet<String>();
                this.missingSatzIds.put(referenceId, saetze);
            }
            saetze.add(satzId);
        }
    }

    @Override
    public void finish() {
        for (Map.Entry<String, Set<String>> entry : this.missingSatzIds.entrySet()) {
            for (String datasetId : entry.getValue()) {
                this.getErrorStatistics().addError(new DatasetError(this.getErrorType(), datasetId));
            }
        }
    }

    public ReferencesStore getReferencesStore() {
        return this.referencesStore;
    }

    @Autowired(required=true)
    public void setReferencesStore(ReferencesStore store) {
        this.referencesStore = store;
        this.referencesStore.addListener((ReferencesStoreListener)this);
    }

    public String getErrorMessage() {
        return null;
    }

    public void datasetFound(String datasetId, String type) {
        if (type == null || type.equals(this.targetDatasetType)) {
            this.missingSatzIds.remove(datasetId);
        }
    }

    public String getTargetDatasetType() {
        return this.targetDatasetType;
    }

    public void setTargetDatasetType(String targetType) {
        this.targetDatasetType = targetType;
    }

    @Override
    public ErrorType getErrorType() {
        ErrorType errorType = super.getErrorType();
        if (errorType == null) {
            errorType = new ReferenceErrorType(this.getKategorie(), this.getTargetDatasetType(), this.getErrorMessageKey(), this.getErrorCode());
            this.setErrorType(errorType);
        }
        return errorType;
    }
}

