/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab2.modules.AbstractMabCheck;
import de.kobv.mable.mab2.modules.PndWithoutNameErrorType;
import java.util.List;

public class PndWithoutName
extends AbstractMabCheck {
    protected int feldnummer1 = 102;
    protected int feldnummer2 = 100;
    protected int increment = 4;
    protected int anzahl = 25;

    @Override
    public void process(MabSatz satz) {
        for (int i = 0; i < this.anzahl; ++i) {
            boolean feld2Found;
            int feld1 = this.feldnummer1 + i * this.increment;
            int feld2 = this.feldnummer2 + i * this.increment;
            List felder1 = satz.getFelder(MabFeldDefinition.getFeld((int)feld1));
            List felder2 = satz.getFelder(MabFeldDefinition.getFeld((int)feld2));
            boolean feld1Found = felder1 != null && felder1.size() > 0;
            boolean bl = feld2Found = felder2 != null && felder2.size() > 0;
            if (!feld1Found || feld2Found) continue;
            this.getErrorStatistics().addError(this.getError(satz));
        }
    }

    protected DatasetError getError(MabSatz satz) {
        return new DatasetError((ErrorType)new PndWithoutNameErrorType(this.getErrorMessageKey(), this.getErrorCode()), satz.getId());
    }
}

