/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab2.modules.AbstractMabCheck;
import de.kobv.mable.mab2.modules.FieldLengthErrorType;
import java.util.List;

public class FieldLength
extends AbstractMabCheck {
    private int min;
    private int max;
    private int length;

    @Override
    public void process(MabSatz satz) {
        List felder = satz.getFelder(this.getKategorie(), this.getIndikator());
        for (IMabFeld feld : felder) {
            String content = feld.getInhalt();
            int contentLength = 0;
            if (content != null) {
                contentLength = content.length();
            }
            if (contentLength >= this.min && contentLength <= this.max) continue;
            this.getErrorStatistics().addError(new DatasetError((ErrorType)new FieldLengthErrorType(this.getKategorie()), satz.getId()));
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        this.length = len;
        this.setMin(this.length);
        this.setMax(this.length);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int maxLength) {
        this.max = maxLength;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int minLength) {
        this.min = minLength;
    }
}

