/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab2.modules.FieldCount;
import org.apache.log4j.Logger;

public class FieldCountAuto
extends FieldCount {
    private static final Logger LOG = Logger.getLogger(FieldCountAuto.class);

    @Override
    public void init() throws MableConfigurationException {
        int max;
        int min;
        String kategorie = this.getKategorie();
        char indikator = this.getIndikator();
        int feldnummer = 0;
        try {
            feldnummer = Integer.parseInt(kategorie);
        }
        catch (NumberFormatException nfe) {
            throw new MableConfigurationException("FieldCountAuto kann nur MAB2 Felder pr\u00fcfen.");
        }
        MabFeldDefinition feld = MabFeldDefinition.getFeld((int)feldnummer);
        if (feld != null) {
            char[] indikatoren;
            min = 0;
            max = feld.getWiederholfaktor();
            if (feld.isRequired()) {
                min = 1;
            }
            if (indikator != '\u0000' && (indikatoren = feld.getIndikatoren()) != null && indikatoren.length > 0 && !feld.isIndikatorWiederholbar() && feld.hatIndikator(indikator)) {
                LOG.debug((Object)("Indikator darf nicht wiederholt werden, daher MAX = 1 fuer " + feld.getFeldnummerString() + indikator + "."));
                max = 1;
            }
        } else {
            throw new MableConfigurationException("Field '" + kategorie + "' nicht gefunden.");
        }
        super.setMin(min);
        super.setMax(max);
    }
}

