/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.mab2;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.config.MableConfig;
import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.IMabUnterfeld;
import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.MabSatzkennung;
import de.kobv.mable.mab.MabUnterfeld;
import de.kobv.mable.mab.extension.ErrorStatistics;
import de.kobv.mable.mab.extension.MableModule2;
import de.kobv.mable.mab.parser.ContentHandler;
import de.kobv.mable.mab2.modules.DatasetStatistics;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class DefaultMabDataHandler
implements ContentHandler {
    private static final Logger LOG = Logger.getLogger(DefaultMabDataHandler.class);
    private MabSatz currentDataset;
    private MabFeld currentField;
    private MableConfig config;
    private String currentDatasetId;
    private String lastDatasetId;
    private Set<MableModule2> modules;
    private ErrorStatistics errorStatistics;
    private MableModule2 datasetStatistics;

    public void startParsing() throws MableConfigurationException {
        this.modules = this.config.getModules();
        for (MableModule2 module : this.modules) {
            module.init();
            if (!(module instanceof DatasetStatistics)) continue;
            this.datasetStatistics = module;
        }
    }

    public void endParsing() {
        for (MableModule2 module : this.modules) {
            module.finish();
        }
    }

    public void startSatz(MabSatzkennung satzkennung) {
        this.currentDataset = new MabSatz(satzkennung.getValue());
    }

    public void endSatz() {
        this.processDataset(this.currentDataset);
        this.lastDatasetId = this.currentDatasetId;
        this.currentDatasetId = null;
        this.errorStatistics.setCurrentDataset001(this.currentDatasetId);
    }

    public void startFeld(String fieldNumber, char indicator, String content) {
        int iFeldnummer;
        assert (fieldNumber.length() == 3);
        try {
            iFeldnummer = Integer.parseInt(fieldNumber);
        }
        catch (NumberFormatException nfe) {
            iFeldnummer = -1;
        }
        if (iFeldnummer >= 1) {
            if (iFeldnummer == 1) {
                this.currentDatasetId = content;
                this.errorStatistics.setCurrentDataset001(this.currentDatasetId);
            }
            this.currentField = new MabFeld(iFeldnummer, indicator, content);
            this.currentDataset.addFeld((IMabFeld)this.currentField);
        }
    }

    public void startUnterfeld(char kennzeichen, String content) {
        this.currentField.addSubfield((IMabUnterfeld)new MabUnterfeld(kennzeichen, content));
    }

    public MabSatz getCurrentDataset() {
        return this.currentDataset;
    }

    public void setConfig(MableConfig config) {
        this.config = config;
    }

    protected void processDataset(MabSatz satz) {
        boolean deleted;
        boolean bl = deleted = satz.getSatzkennung().getStatus() == 'd';
        if (deleted && this.datasetStatistics != null) {
            this.datasetStatistics.process(satz);
        } else {
            for (MableModule2 module : this.modules) {
                module.process(satz);
            }
        }
    }

    @Autowired
    @Required
    public void setErrorStatistics(ErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public String getLastDatasetId() {
        return this.lastDatasetId;
    }
}

