/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.kernels;

import de.kobv.mable.mab.parser.MabParser;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;

public class ProgressMonitor
extends TimerTask {
    private MabParser parser;
    private int totalDatasets = 0;
    private long startTime = System.currentTimeMillis();
    private int processedBefore = 0;
    private int digits;

    @Override
    public void run() {
        int datasetsProcessed = this.parser.getDatasetsProcessed();
        int averageSpeed = datasetsProcessed - this.processedBefore;
        this.processedBefore = datasetsProcessed;
        String output = null;
        if (this.totalDatasets > 0) {
            int percentProcessed = datasetsProcessed * 100 / this.totalDatasets;
            long timeUsed = System.currentTimeMillis() - this.startTime;
            int datasetsRemaining = this.totalDatasets - datasetsProcessed;
            long timeLeft = 0L;
            try {
                timeLeft = timeUsed * (long)datasetsRemaining / (long)datasetsProcessed / 1000L;
            }
            catch (ArithmeticException e) {
                timeLeft = 0L;
            }
            String timeLeftStr = this.formatTimeLeft(timeLeft);
            output = String.format("Processing: %1$" + this.digits + "d (%2$3d %%) %3$5d datasets/s [ETA " + timeLeftStr + "]", datasetsProcessed, percentProcessed, averageSpeed);
        } else {
            output = String.format("Processing: %1$10d [%2$d datasets/s]", datasetsProcessed, averageSpeed);
        }
        output = StringUtils.rightPad((String)output, (int)79);
        System.out.print("\r" + output);
    }

    public void finish() {
        System.out.print(StringUtils.rightPad((String)"\r", (int)79, (String)" ") + "\r");
    }

    public MabParser getParser() {
        return this.parser;
    }

    public void setParser(MabParser mabParser) {
        this.parser = mabParser;
    }

    public long getTotalDatasets() {
        return this.totalDatasets;
    }

    public void setTotalDatasets(int total) {
        this.totalDatasets = total;
        this.digits = Integer.toString(this.totalDatasets).length();
    }

    protected String formatTimeLeft(long time) {
        long sec = time % 60L;
        long min = time / 60L % 60L;
        long hours = time / 60L / 60L % 60L;
        StringBuilder output = new StringBuilder();
        if (hours > 0L) {
            output.append(String.format("%1$02dh", hours));
        }
        if (min > 0L) {
            output.append(String.format("%1$02dm", min));
        }
        output.append(String.format("%1$02ds", sec));
        return output.toString();
    }
}

