/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.kernels;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.kernels.AbstractKernel;
import de.kobv.mable.kernels.ProgressMonitor;
import de.kobv.mable.mab.parser.MabParser;
import de.kobv.mable.mab.xml.MabXmlParser;
import de.kobv.mable.reports.Report;
import de.kobv.mable.util.XmlResourceBundleControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CheckKernel
extends AbstractKernel
implements ApplicationContextAware {
    private static final Logger LOG = Logger.getLogger(CheckKernel.class);
    private static final long MONITOR_INTERVAL = 1000L;
    private static final int LINE_WIDTH = 80;
    private static final int MILLISECONDS = 1000;
    private ApplicationContext context;
    private int totalDatasets;
    private ResourceBundle messages = ResourceBundle.getBundle("de/kobv/mable/cli/mable-cli-messages", (ResourceBundle.Control)new XmlResourceBundleControl());
    private Reader source;
    private InputStream stream;
    private String filename;
    private boolean fastMode;
    private boolean quietMode;
    private boolean mabxmlInput;

    public void setApplicationContext(ApplicationContext ac) {
        this.context = ac;
    }

    public void start() throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String name = this.getFilename();
        if (name == null) {
            LOG.warn((Object)"Name der einzulesenden MAB-Datei konnte nicht gelesen werden");
            System.exit(-1);
        }
        Date timestamp = new Date();
        String logTimestamp = df.format(timestamp);
        MableProperties.setProperty((String)"timestamp", (Object)timestamp);
        MableProperties.setProperty((String)"timestampString", (Object)logTimestamp);
        MableProperties.setProperty((String)"workpath", (Object)System.getProperty("user.dir"));
        MableProperties.setProperty((String)"filename", (Object)name);
        this.processMAB2Band(name);
    }

    protected void processMAB2Band(String name) {
        MabParser parser = this.getParser();
        try {
            try {
                ProgressMonitor monitor = null;
                if (!this.isQuietMode()) {
                    monitor = new ProgressMonitor();
                    monitor.setParser(parser);
                    monitor.setTotalDatasets(this.totalDatasets);
                }
                if (this.stream != null) {
                    parser.setSource(this.stream);
                } else if (this.source != null) {
                    parser.setSource(this.source);
                }
                long timestamp = System.currentTimeMillis();
                Timer timer = null;
                if (monitor != null) {
                    timer = new Timer("Monitor");
                    timer.schedule((TimerTask)monitor, 0L, 1000L);
                }
                parser.parse();
                if (monitor != null) {
                    timer.cancel();
                    monitor.finish();
                }
                double totalTime = System.currentTimeMillis() - timestamp;
                MableProperties.setProperty((String)"totalTime", (Object)totalTime);
                String unit = "ms";
                if (totalTime > 1000.0) {
                    unit = "s";
                    totalTime /= 1000.0;
                }
                if (!this.quietMode) {
                    System.console().writer().println(StringUtils.rightPad((String)(this.messages.getString("mable.cli.totalTime") + " " + totalTime + " " + unit), (int)79, (char)' '));
                }
                MableProperties.setProperty((String)"datasetsProcessed", (Object)parser.getDatasetsProcessed());
                MableProperties.setProperty((String)"datasetsIgnored", (Object)parser.getDatasetsIgnored());
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Beim Lesen der MAB-Datei oder beim Schreiben der Logdatei ist ein Fehler aufgetreten: " + ioe.getMessage()), (Throwable)ioe);
                LOG.warn((Object)"ABBRUCH.");
                LOG.warn((Object)"Beim Lesen der MAB-Datei oder beim Schreiben der Logdatei ist ein Fehler aufgetreten, Details siehe Report");
                System.exit(-1);
            }
            catch (ParseException pe) {
                LOG.fatal((Object)("Es ist ein interner Fehler aufgetreten:" + pe.getMessage()), (Throwable)pe);
                LOG.warn((Object)"ABBRUCH.");
                LOG.fatal((Object)("Es ist ein interne Fehler aufgetreten: " + pe.getMessage()), (Throwable)pe);
                System.exit(-1);
            }
            this.generateReports();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)("S\u00e4tze verarbeitet: " + parser.getDatasetsProcessed()));
            LOG.error((Object)("Letzter Satz: " + parser.getContentHandler().getLastDatasetId()));
            System.exit(-1);
        }
    }

    protected void generateReports() {
        Map checkers = this.context.getBeansOfType(Report.class);
        for (Map.Entry entry : checkers.entrySet()) {
            Report reportModule = (Report)entry.getValue();
            reportModule.generate();
        }
    }

    public MabParser getParser() {
        Object parser = this.mabxmlInput ? (MabXmlParser)this.context.getBean("mabxmlParser") : (this.fastMode ? (MabParser)this.context.getBean("fastParser") : (MabParser)this.context.getBean("mabParser"));
        return parser;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String name) {
        this.filename = name;
    }

    public int getTotalDatasets() {
        return this.totalDatasets;
    }

    public void setTotalDatasets(int total) {
        this.totalDatasets = total;
    }

    public void setSource(Reader src) {
        this.source = src;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public boolean isFastMode() {
        return this.fastMode;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public boolean isMabxmlInput() {
        return this.mabxmlInput;
    }

    public void setMabxmlInput(boolean mabxmlInput) {
        this.mabxmlInput = mabxmlInput;
    }
}

