/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.cli;

import de.kobv.mable.cli.AbstractMableCommand;
import de.kobv.mable.mab.parser.MabDatasetIndexer;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class IndexCommand
extends AbstractMableCommand {
    private static final Logger LOG = Logger.getLogger(IndexCommand.class);
    private String outputFile;

    public void execute() {
        InputStream source = this.getSource();
        if (source == null) {
            return;
        }
        MabDatasetIndexer indexer = new MabDatasetIndexer();
        long totalTime = 0L;
        try {
            Writer output = this.getOutput();
            indexer.setOutput(output);
            indexer.setSource(source);
            long timestamp = System.currentTimeMillis();
            indexer.index();
            totalTime = System.currentTimeMillis() - timestamp;
            output.close();
            if (!this.isQuietMode()) {
                this.getOutput().write(String.format("%1$d S\u00e4tze durchsucht (%2$d ms)%n", indexer.getDatasetCounter(), totalTime));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private InputStream getSource() {
        BufferedInputStream source = null;
        try {
            source = new BufferedInputStream(new FileInputStream(this.getFilename()));
        }
        catch (FileNotFoundException fnfe) {
            LOG.error((Object)this.getMessages().getString("error.fileNotFound"));
        }
        return source;
    }

    private Writer getOutput() throws IOException {
        if (this.outputFile == null) {
            Console console = System.console();
            if (console != null) {
                return System.console().writer();
            }
            return new OutputStreamWriter(System.out);
        }
        return new FileWriter(this.outputFile);
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }
}

