/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.cli;

import de.kobv.mable.ErrorCode;
import de.kobv.mable.cli.AbstractMableCommand;
import de.kobv.mable.util.ErrorsReportFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.log4j.Logger;

public class FilterErrorsCommand
extends AbstractMableCommand {
    private static final Logger LOG = Logger.getLogger(FilterErrorsCommand.class);
    private int errorCode;
    private String datasetId;

    public void execute() {
        Set result;
        String filename = this.getFilename();
        File file = new File(filename);
        if (!file.exists() || file.isFile()) {
            // empty if block
        }
        try {
            FileReader source = new FileReader(this.getFilename());
            ErrorsReportFilter filter = new ErrorsReportFilter();
            filter.setSource((Reader)source);
            filter.setErrorCode(this.getErrorCode());
            filter.setDatasetId(this.getDatasetId());
            result = filter.filter();
            if (this.getDatasetId() != null) {
                System.out.println("For dataset " + this.getDatasetId() + " the following errors were found:");
                for (String error : result) {
                    ErrorCode code = ErrorCode.get((int)Integer.parseInt(error));
                    if (code != null) {
                        System.out.println(error + " : " + code.getMessage());
                        continue;
                    }
                    System.out.println(error + " : " + "NO INFO");
                }
            } else {
                for (String id : result) {
                    System.out.println(id);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        catch (IOException ioe) {
            return;
        }
        System.out.println("Results found: " + result.size());
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }
}

