/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.cli;

import de.kobv.mable.cli.AbstractMableCommand;
import de.kobv.mable.mab.parser.MabDatasetFinder;
import gov.ornl.sns.cli.InvalidOptionException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.log4j.Logger;

public class ExtractCommand
extends AbstractMableCommand {
    private static final Logger LOG = Logger.getLogger(ExtractCommand.class);
    private String[] datasetIds;
    private String outputFile;
    private String inputFile;
    private Reader input;

    public void prepare() throws MissingOptionException, InvalidOptionException, MissingArgumentException {
        super.prepare();
        try {
            if (this.inputFile != null) {
                this.input = new FileReader(this.inputFile);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new InvalidOptionException("Input file not found.");
        }
    }

    public void execute() {
        FileInputStream source;
        try {
            source = new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            LOG.error((Object)this.getMessages().getString("error.fileNotFound"));
            return;
        }
        MabDatasetFinder finder = new MabDatasetFinder();
        finder.setSource((InputStream)source);
        long totalTime = 0L;
        try {
            long timestamp = System.currentTimeMillis();
            OutputStream output = this.getOutputStream();
            LOG.debug((Object)this.datasetIds);
            finder.find(this.getIdentifiers(), output);
            if (!this.isQuietMode()) {
                System.out.println();
            }
            totalTime = System.currentTimeMillis() - timestamp;
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        if (!this.isQuietMode()) {
            System.console().writer().println(finder.getDatasetCounter() + " S\u00e4tze durchsucht (" + totalTime + " ms)");
        }
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        OutputStream out = null;
        out = this.outputFile == null ? System.out : new FileOutputStream(this.outputFile);
        return out;
    }

    public Set<String> getIdentifiers() throws IOException {
        HashSet<String> identifiers = new HashSet<String>();
        if (this.input != null) {
            String line;
            BufferedReader in = new BufferedReader(this.input);
            while ((line = in.readLine()) != null) {
                identifiers.add(line);
            }
        } else if (this.datasetIds != null) {
            identifiers.addAll(Arrays.asList(this.datasetIds));
        } else {
            String line;
            while ((line = System.console().readLine()) != null) {
                identifiers.add(line);
            }
        }
        return identifiers;
    }

    public String[] getDatasetIds() {
        return this.datasetIds;
    }

    public void setDatasetIds(String[] identifier) {
        this.datasetIds = identifier;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }
}

