/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.cli;

import de.kobv.mable.cli.AbstractMableCommand;
import de.kobv.mable.mab.parser.MabDatasetCounter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Logger;

public class CountCommand
extends AbstractMableCommand {
    private static final Logger LOG = Logger.getLogger(CountCommand.class);

    public void execute() {
        FileReader source;
        try {
            source = new FileReader(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            LOG.error((Object)this.getMessages().getString("error.fileNotFound"));
            return;
        }
        MabDatasetCounter counter = new MabDatasetCounter();
        counter.setSource((Reader)source);
        long totalTime = 0L;
        try {
            long timestamp = System.currentTimeMillis();
            counter.parse();
            totalTime = System.currentTimeMillis() - timestamp;
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        System.console().writer().println(counter.getDatasetCounter() + " S\u00e4tze gefunden (" + totalTime + " ms)");
    }
}

