/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.cli;

import de.ddb.charset.MabCharset;
import de.kobv.mable.cli.AbstractMableCommand;
import de.kobv.mable.common.MableProperties;
import de.kobv.mable.kernels.CheckKernel;
import de.kobv.mable.mab.parser.MabDatasetCounter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class CheckCommand
extends AbstractMableCommand {
    private static final Logger LOG = Logger.getLogger(CheckCommand.class);
    private boolean fastParser;
    private static final String DEFAULT_CONFIG_FILE = "de/kobv/mable/cli/spring-config-nosql.xml";
    private String configFile = null;

    public void execute() {
        FileInputStream in;
        int totalDatasets;
        InputStreamReader source;
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(this.getConfigFile());
        try {
            source = new FileReader(this.getFilename());
            if (!this.isQuietMode()) {
                System.out.println(this.getMessages().getString("mable.cli.prepare"));
            }
            if (!this.getFilename().endsWith(".xml")) {
                MabDatasetCounter counter = new MabDatasetCounter();
                counter.setSource((Reader)source);
                counter.parse();
                totalDatasets = counter.getDatasetCounter();
            } else {
                totalDatasets = 0;
            }
            MableProperties.setProperty((String)"dataset.count", (Object)totalDatasets);
            MableProperties.setProperty((String)"filename", (Object)this.getFilename());
            in = new FileInputStream(this.getFilename());
            if (this.isUtf8encoded()) {
                System.out.println("Not using MAB charset.");
                source = new InputStreamReader(in);
            } else {
                source = new InputStreamReader((InputStream)in, (Charset)new MabCharset());
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(this.getMessages().getString("error.fileNotFound"));
            return;
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error reading file", (Throwable)ioe);
            return;
        }
        CheckKernel kernel = (CheckKernel)context.getBean(CheckKernel.class);
        kernel.setQuietMode(this.isQuietMode());
        try {
            kernel.setTotalDatasets(totalDatasets);
            kernel.setFilename(this.getFilename());
            String extension = FilenameUtils.getExtension((String)this.getFilename());
            if (extension.contains("xml")) {
                kernel.setMabxmlInput(true);
                kernel.setStream(in);
            } else if (this.isFastParser()) {
                kernel.setStream(in);
                kernel.setFastMode(true);
            } else {
                kernel.setSource(source);
                kernel.setFastMode(false);
            }
            kernel.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception", (Throwable)e);
        }
    }

    public boolean isFastParser() {
        return this.fastParser;
    }

    public void setFastParser(boolean enabled) {
        this.fastParser = enabled;
    }

    public void setConfigPath(String path) {
        this.configFile = path;
    }

    private String getConfigFile() {
        if (this.configFile != null) {
            return this.configFile;
        }
        return DEFAULT_CONFIG_FILE;
    }
}

