/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.cli;

import de.kobv.mable.cli.AbstractMableCommand;
import de.kobv.mable.util.ErrorCodeIndexReportParser;
import de.kobv.mable.util.SatzfehlerStatistics;
import de.kobv.mable.util.SubsetSatzfehlerStatistics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalyseErrorsCommand
extends AbstractMableCommand {
    private static final Logger LOG = Logger.getLogger(AnalyseErrorsCommand.class);

    public void execute() {
        String filename = this.getFilename();
        File file = new File(filename);
        if (!file.exists() || file.isFile()) {
            // empty if block
        }
        try {
            FileReader source = new FileReader(this.getFilename());
            SatzfehlerStatistics statistics = new SatzfehlerStatistics();
            statistics.parse((Reader)source);
            Map result = statistics.getNumberOfDatasetsWithErrorCount();
            PrintWriter writer = System.console().writer();
            int digitsForFehler = this.digitsOfBiggestValue(result.keySet());
            writer.println("Fehler -> S\u00e4tze");
            for (Map.Entry entry : result.entrySet()) {
                writer.println(String.format("%1$" + digitsForFehler + "d -> %2$d", entry.getKey(), entry.getValue()));
            }
            writer.println();
            SubsetSatzfehlerStatistics subset = new SubsetSatzfehlerStatistics();
            subset.setErrorsForDataset(statistics.getErrorsForDataset());
            subset.parse((Reader)new FileReader(this.getFilename()));
            String codesFilename = this.getCodesFilename(this.getFilename());
            ErrorCodeIndexReportParser codeParser = new ErrorCodeIndexReportParser();
            codeParser.parse((Reader)new FileReader(codesFilename));
            for (Map.Entry entry : result.entrySet()) {
                if ((Integer)entry.getKey() == 1) {
                    writer.println("S\u00e4tze mit einem Fehler");
                } else {
                    writer.println("S\u00e4tze mit " + entry.getKey() + " Fehlern");
                }
                Map details = subset.getErrorsForDatasets(((Integer)entry.getKey()).intValue());
                writer.println(" Anzahl -> Fehler");
                for (Map.Entry fehlerEntry : details.entrySet()) {
                    String message = codeParser.getMessageForCode((String)fehlerEntry.getKey());
                    digitsForFehler = this.digitsOfBiggestValue(details.values());
                    writer.println(String.format("  %1$" + digitsForFehler + "d -> (#%2$s) %3$s", fehlerEntry.getValue(), fehlerEntry.getKey(), message));
                }
                writer.println();
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int digitsOfBiggestValue(Collection<Integer> values) {
        int biggestValue = 0;
        for (Integer value : values) {
            if (value <= biggestValue) continue;
            biggestValue = value;
        }
        return Integer.toString(biggestValue).length();
    }

    protected String getCodesFilename(String filename) {
        return filename.substring(0, filename.length() - 11) + "-codes.txt";
    }
}

