/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset.normalizer;

import de.ddb.charset.normalizer.Normalizer;
import de.ddb.charset.normalizer.impl.JavaTextNormalizer;
import de.ddb.charset.normalizer.impl.SunTextNormalizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NormalizerFactory {
    private static Log logger = LogFactory.getLog(NormalizerFactory.class);
    private static Normalizer normalizer;
    private static Class[] normalizers;

    public static Normalizer getInstance() throws ClassNotFoundException {
        if (normalizer == null) {
            for (int i = 0; i < normalizers.length && normalizer == null; ++i) {
                try {
                    normalizer = (Normalizer)normalizers[i].newInstance();
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Normalizer initialized: " + normalizers[i]));
                    continue;
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Could not initialize " + normalizers[i]));
                }
            }
            if (normalizer == null) {
                throw new ClassNotFoundException("Could not find any normalizer.");
            }
        }
        return normalizer;
    }

    static {
        normalizers = new Class[]{JavaTextNormalizer.class, SunTextNormalizer.class};
    }
}

