/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import de.ddb.charset.normalizer.Normalizer;
import de.ddb.charset.normalizer.NormalizerFactory;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SingleByteEncoder
extends CharsetEncoder {
    private static Log logger = LogFactory.getLog(SingleByteEncoder.class);
    private boolean decomposeCharactersBeforeConversion = true;
    private Normalizer normalizer;

    public boolean isDecomposeCharactersBeforeConversion() {
        return this.decomposeCharactersBeforeConversion;
    }

    public void setDecomposeCharactersBeforeConversion(boolean bl) {
        this.decomposeCharactersBeforeConversion = bl;
    }

    protected SingleByteEncoder(Charset charset) {
        super(charset, 1.0f, 2.0f);
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        String string;
        char c = '\u0000';
        LinkedList<Character> linkedList = new LinkedList<Character>();
        int n2 = 0;
        while (charBuffer.hasRemaining()) {
            char c2 = charBuffer.get();
            ++n2;
            if (c != '\u0000' && !this.isCombiningCharacter(c2)) {
                string = String.valueOf(c);
                if (this.isDecomposeCharactersBeforeConversion()) {
                    try {
                        string = this.getNormalizer().decompose(String.valueOf(c));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.error((Object)"Could not decompose char due to missing normalizer.", (Throwable)classNotFoundException);
                    }
                }
                if (byteBuffer.remaining() < string.length() + linkedList.size()) {
                    logger.debug((Object)("Overflow: input position: " + charBuffer.position()));
                    charBuffer.position(charBuffer.position() - n2);
                    logger.debug((Object)("Overflow: returning to: " + charBuffer.position()));
                    return CoderResult.OVERFLOW;
                }
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    char c3 = ((Character)iterator.next()).charValue();
                    this.convert(c3, byteBuffer);
                    --n2;
                }
                for (n = string.length() - 1; n >= 0; --n) {
                    this.convert(string.charAt(n), byteBuffer);
                }
                --n2;
                linkedList.clear();
                c = '\u0000';
            }
            if (!this.isCombiningCharacter(c2)) {
                c = c2;
                continue;
            }
            linkedList.add(Character.valueOf(c2));
        }
        if (c != '\u0000') {
            string = String.valueOf(c);
            string = this.normalize(string);
            if (byteBuffer.remaining() < string.length() + linkedList.size()) {
                charBuffer.position(charBuffer.position() - n2);
                return CoderResult.OVERFLOW;
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                n = ((Character)iterator.next()).charValue();
                this.convert((char)n, byteBuffer);
            }
            for (int i = string.length() - 1; i >= 0; --i) {
                this.convert(string.charAt(i), byteBuffer);
            }
        }
        string = null;
        linkedList = null;
        return CoderResult.UNDERFLOW;
    }

    public byte charToByte(char c) {
        return (byte)c;
    }

    public boolean isCombiningCharacter(char c) {
        return c >= '\u0300' && c <= '\u036f';
    }

    protected void convert(char c, ByteBuffer byteBuffer) {
        byte by = this.charToByte(c);
        if (by != 0) {
            byteBuffer.put(by);
        } else {
            byteBuffer.put(this.replacement());
        }
    }

    private String normalize(String string) {
        try {
            string = this.isDecomposeCharactersBeforeConversion() ? this.getNormalizer().decompose(string) : this.getNormalizer().compose(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.warn((Object)("Could not compose char due to missing normalizer." + classNotFoundException.getMessage()));
        }
        return string;
    }

    private Normalizer getNormalizer() throws ClassNotFoundException {
        if (this.normalizer == null) {
            this.normalizer = NormalizerFactory.getInstance();
        }
        return this.normalizer;
    }
}

