/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import de.ddb.charset.Utils;
import de.ddb.charset.normalizer.Normalizer;
import de.ddb.charset.normalizer.NormalizerFactory;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SingleByteDecoder
extends CharsetDecoder {
    private static Log logger = LogFactory.getLog(SingleByteDecoder.class);
    private boolean composeCharactersAfterConversion = false;
    private Normalizer normalizer;

    public boolean isComposeCharactersAfterConversion() {
        return this.composeCharactersAfterConversion;
    }

    public void setComposeCharactersAfterConversion(boolean bl) {
        this.composeCharactersAfterConversion = bl;
    }

    protected SingleByteDecoder(Charset charset) {
        super(charset, 1.0f, 1.0f);
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(30);
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (Character.isISOControl(by) && byteBuffer2.position() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("clear buffer. inputBuffer=" + Utils.toHexString(byteBuffer2.array())));
                }
                for (int i = 0; i < byteBuffer2.position(); ++i) {
                    charBuffer.put("?");
                }
                byteBuffer2.clear();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Storing [" + Integer.toHexString(by & 0xFF) + "]."));
            }
            byteBuffer2.put(by);
            String string = null;
            if (!this.isCombiningCharacter(by)) {
                string = this.convertBuffer(byteBuffer2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting [" + byteBuffer2.toString() + "] to [" + string + "]"));
                }
            }
            if (string == null) continue;
            if (charBuffer.remaining() < string.length()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Overflow. Resetting input buffer to position " + (byteBuffer.position() - byteBuffer2.position())));
                }
                byteBuffer.position(byteBuffer.position() - byteBuffer2.position());
                return CoderResult.OVERFLOW;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Writing to output buffer. [position=" + charBuffer.position() + ", limit=" + charBuffer.limit() + ", cap=" + charBuffer.capacity() + "]"));
            }
            charBuffer.append(string);
            byteBuffer2.clear();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Underflow. Resetting input buffer to position " + (byteBuffer.position() - byteBuffer2.position())));
        }
        byteBuffer.position(byteBuffer.position() - byteBuffer2.position());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Underflow");
        }
        return CoderResult.UNDERFLOW;
    }

    public String convertBuffer(ByteBuffer byteBuffer) {
        int n;
        String string = "";
        for (int i = byteBuffer.position() - 1; i >= 0; --i) {
            n = this.byteToChar(byteBuffer.get(i));
            String string2 = n == 0 ? this.replacement() : String.valueOf((char)n);
            string = string + string2;
        }
        try {
            this.normalizer = NormalizerFactory.getInstance();
            if (this.composeCharactersAfterConversion) {
                string = this.normalizer.compose(string);
                if (logger.isDebugEnabled()) {
                    String string3 = "";
                    for (n = 0; n < string.length(); ++n) {
                        string3 = string3 + Integer.toHexString(string.charAt(n));
                    }
                    logger.debug((Object)("Composing (to single character) [" + string3 + "]"));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    String string4 = "";
                    for (n = 0; n < string.length(); ++n) {
                        string4 = string4 + Integer.toHexString(string.charAt(n));
                    }
                    logger.debug((Object)("Decomposing (into two seperate characters) [" + string4 + "]"));
                }
                string = this.normalizer.decompose(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)("Could not normalize buffer. " + classNotFoundException.getMessage()));
        }
        return string;
    }

    public abstract boolean isCombiningCharacter(byte var1);

    public abstract char byteToChar(byte var1);
}

