/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import de.ddb.charset.SingleByteDecoder;
import de.ddb.charset.SingleByteEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicaCharset
extends Charset {
    public static final char END_OF_RECORD = '\u001d';
    public static final char END_OF_FIELD = '\u001e';
    public static final char START_OF_SUBFIELD = '\u001f';
    static final char[] BYTE_TO_CHAR_MAP = PicaCharset.newPicaToUnicodeMap();
    static final Map<Character, Byte> CHAR_TO_BYTE_MAP = PicaCharset.newCharToByteMap();
    private boolean nfc = false;

    public PicaCharset() {
        this(false);
    }

    public PicaCharset(boolean bl) {
        super("x-PICA", null);
        this.nfc = bl;
    }

    private static char[] newPicaToUnicodeMap() {
        char[] cArray = new char[256];
        for (int i = 0; i < 128; ++i) {
            cArray[i] = (char)i;
        }
        cArray[128] = 8225;
        cArray[129] = 152;
        cArray[130] = 156;
        cArray[131] = 124;
        cArray[132] = 117;
        cArray[133] = 122;
        cArray[134] = 97;
        cArray[156] = 698;
        cArray[161] = 321;
        cArray[162] = 216;
        cArray[163] = 272;
        cArray[164] = 222;
        cArray[165] = 198;
        cArray[166] = 338;
        cArray[167] = 697;
        cArray[168] = 183;
        cArray[169] = 9837;
        cArray[170] = 174;
        cArray[171] = 177;
        cArray[172] = 416;
        cArray[173] = 431;
        cArray[174] = 700;
        cArray[175] = 197;
        cArray[176] = 699;
        cArray[177] = 322;
        cArray[178] = 248;
        cArray[179] = 273;
        cArray[180] = 254;
        cArray[181] = 230;
        cArray[182] = 339;
        cArray[183] = 698;
        cArray[184] = 305;
        cArray[185] = 163;
        cArray[186] = 240;
        cArray[187] = 945;
        cArray[188] = 417;
        cArray[189] = 432;
        cArray[190] = 223;
        cArray[191] = 229;
        cArray[192] = 306;
        cArray[193] = 196;
        cArray[194] = 214;
        cArray[195] = 220;
        cArray[196] = 390;
        cArray[197] = 398;
        cArray[198] = 8800;
        cArray[199] = 8594;
        cArray[200] = 8804;
        cArray[201] = 8734;
        cArray[202] = 8747;
        cArray[203] = 215;
        cArray[204] = 167;
        cArray[205] = 8730;
        cArray[206] = 8823;
        cArray[207] = 8805;
        cArray[208] = 307;
        cArray[209] = 228;
        cArray[210] = 246;
        cArray[211] = 252;
        cArray[212] = 596;
        cArray[213] = 477;
        cArray[214] = 191;
        cArray[215] = 161;
        cArray[216] = 946;
        cArray[218] = 947;
        cArray[219] = 960;
        cArray[224] = 777;
        cArray[225] = 768;
        cArray[226] = 769;
        cArray[227] = 770;
        cArray[228] = 771;
        cArray[229] = 772;
        cArray[230] = 774;
        cArray[231] = 775;
        cArray[232] = 776;
        cArray[233] = 780;
        cArray[234] = 778;
        cArray[235] = 65056;
        cArray[236] = 65057;
        cArray[237] = 787;
        cArray[238] = 779;
        cArray[239] = 784;
        cArray[240] = 807;
        cArray[242] = 803;
        cArray[243] = 804;
        cArray[244] = 805;
        cArray[245] = 819;
        cArray[246] = 817;
        cArray[248] = 808;
        cArray[249] = 814;
        cArray[250] = 65059;
        cArray[251] = 65058;
        cArray[254] = 789;
        return cArray;
    }

    private static Map<Character, Byte> newCharToByteMap() {
        char[] cArray = (char[])BYTE_TO_CHAR_MAP.clone();
        cArray[128] = 128;
        cArray[129] = 129;
        cArray[130] = 130;
        cArray[131] = 131;
        cArray[132] = 132;
        cArray[133] = 133;
        cArray[134] = 134;
        cArray[156] = 156;
        HashMap<Character, Byte> hashMap = new HashMap<Character, Byte>(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\u0000' || hashMap.containsKey(Character.valueOf(cArray[i]))) continue;
            hashMap.put(new Character(cArray[i]), new Byte((byte)i));
        }
        return hashMap;
    }

    @Override
    public boolean contains(Charset charset) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        PicaDecoder picaDecoder = new PicaDecoder(this);
        picaDecoder.setComposeCharactersAfterConversion(this.nfc);
        return picaDecoder;
    }

    @Override
    public CharsetEncoder newEncoder() {
        PicaEncoder picaEncoder = new PicaEncoder(this);
        return picaEncoder;
    }

    class PicaEncoder
    extends SingleByteEncoder {
        protected PicaEncoder(Charset charset) {
            super(charset);
        }

        public byte charToByte(char c) {
            Byte by = CHAR_TO_BYTE_MAP.get(Character.valueOf(c));
            if (by == null) {
                return 0;
            }
            return by;
        }
    }

    class PicaDecoder
    extends SingleByteDecoder {
        protected PicaDecoder(Charset charset) {
            super(charset);
        }

        public char byteToChar(byte by) {
            return BYTE_TO_CHAR_MAP[by & 0xFF];
        }

        public boolean isCombiningCharacter(byte by) {
            return (by & 0xFF) >= 224 && (by & 0xFF) <= 254;
        }
    }
}

