/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import de.ddb.charset.SingleByteDecoder;
import de.ddb.charset.normalizer.Normalizer;
import de.ddb.charset.normalizer.NormalizerFactory;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MabDisketteCharset
extends Charset {
    private boolean nfc;
    private static final Log logger = LogFactory.getLog(MabDisketteCharset.class);
    private Normalizer normalizer;
    private static char[] byteToCharTable = MabDisketteCharset.newMabCharsetMap();
    public static final Map<Character, Byte> charToByteTable = MabDisketteCharset.newMabByteToCharMap();

    public MabDisketteCharset() {
        super("cp-850", new String[]{"CP850"});
    }

    @Override
    public boolean contains(Charset charset) {
        return false;
    }

    public static char[] newMabCharsetMap() {
        char[] cArray = new char[256];
        for (int i = 0; i < 128; ++i) {
            cArray[i] = (char)i;
        }
        cArray[128] = 199;
        cArray[129] = 252;
        cArray[130] = 233;
        cArray[131] = 226;
        cArray[132] = 228;
        cArray[133] = 224;
        cArray[134] = 229;
        cArray[135] = 231;
        cArray[136] = 234;
        cArray[137] = 235;
        cArray[138] = 232;
        cArray[139] = 239;
        cArray[140] = 238;
        cArray[141] = 236;
        cArray[142] = 196;
        cArray[143] = 197;
        cArray[144] = 201;
        cArray[145] = 230;
        cArray[146] = 198;
        cArray[147] = 244;
        cArray[148] = 246;
        cArray[149] = 242;
        cArray[150] = 251;
        cArray[151] = 249;
        cArray[152] = 255;
        cArray[153] = 214;
        cArray[154] = 220;
        cArray[155] = 248;
        cArray[156] = 163;
        cArray[157] = 216;
        cArray[158] = 215;
        cArray[159] = 402;
        cArray[160] = 225;
        cArray[161] = 237;
        cArray[162] = 243;
        cArray[163] = 250;
        cArray[164] = 241;
        cArray[165] = 209;
        cArray[166] = 170;
        cArray[167] = 186;
        cArray[168] = 191;
        cArray[169] = 174;
        cArray[170] = 172;
        cArray[171] = 189;
        cArray[172] = 188;
        cArray[173] = 161;
        cArray[174] = 171;
        cArray[175] = 187;
        cArray[176] = 9617;
        cArray[177] = 9618;
        cArray[178] = 9619;
        cArray[179] = 9474;
        cArray[180] = 9508;
        cArray[181] = 193;
        cArray[182] = 194;
        cArray[183] = 192;
        cArray[184] = 169;
        cArray[185] = 9571;
        cArray[186] = 9553;
        cArray[187] = 9559;
        cArray[188] = 9565;
        cArray[189] = 162;
        cArray[190] = 165;
        cArray[191] = 9488;
        cArray[192] = 9492;
        cArray[193] = 9524;
        cArray[194] = 9516;
        cArray[195] = 9500;
        cArray[196] = 9472;
        cArray[197] = 9532;
        cArray[198] = 227;
        cArray[199] = 195;
        cArray[200] = 9562;
        cArray[201] = 9556;
        cArray[202] = 9577;
        cArray[203] = 9574;
        cArray[204] = 9568;
        cArray[205] = 9552;
        cArray[206] = 9580;
        cArray[207] = 164;
        cArray[208] = 240;
        cArray[209] = 208;
        cArray[210] = 202;
        cArray[211] = 203;
        cArray[212] = 200;
        cArray[213] = 305;
        cArray[214] = 205;
        cArray[215] = 206;
        cArray[216] = 207;
        cArray[217] = 9496;
        cArray[218] = 9484;
        cArray[219] = 9608;
        cArray[220] = 9604;
        cArray[221] = 166;
        cArray[222] = 204;
        cArray[223] = 9600;
        cArray[224] = 211;
        cArray[225] = 223;
        cArray[226] = 212;
        cArray[227] = 210;
        cArray[228] = 245;
        cArray[229] = 213;
        cArray[230] = 181;
        cArray[231] = 254;
        cArray[232] = 222;
        cArray[233] = 218;
        cArray[234] = 219;
        cArray[235] = 217;
        cArray[236] = 253;
        cArray[237] = 221;
        cArray[238] = 175;
        cArray[239] = 180;
        cArray[240] = 173;
        cArray[241] = 177;
        cArray[242] = 8215;
        cArray[243] = 190;
        cArray[244] = 182;
        cArray[245] = 167;
        cArray[246] = 247;
        cArray[247] = 184;
        cArray[248] = 176;
        cArray[249] = 168;
        cArray[250] = 183;
        cArray[251] = 185;
        cArray[252] = 179;
        cArray[253] = 178;
        cArray[254] = 9632;
        cArray[255] = 160;
        return cArray;
    }

    public static Map<Character, Byte> newMabByteToCharMap() {
        HashMap<Character, Byte> hashMap = new HashMap<Character, Byte>(byteToCharTable.length);
        for (int i = 0; i < byteToCharTable.length; ++i) {
            if (byteToCharTable[i] == '\u0000' || hashMap.containsKey(Character.valueOf(byteToCharTable[i]))) continue;
            hashMap.put(new Character(byteToCharTable[i]), new Byte((byte)i));
        }
        hashMap.put(Character.valueOf('\u02b9'), (byte)39);
        hashMap.put(Character.valueOf('\u0141'), (byte)76);
        hashMap.put(Character.valueOf('\u0111'), (byte)100);
        hashMap.put(Character.valueOf('\u0142'), (byte)108);
        hashMap.put(Character.valueOf('\u02ba'), (byte)-73);
        hashMap.put(Character.valueOf('\u0110'), (byte)-47);
        return hashMap;
    }

    @Override
    public CharsetEncoder newEncoder() {
        MabDisketteEncoder mabDisketteEncoder = new MabDisketteEncoder(this);
        return mabDisketteEncoder;
    }

    @Override
    public CharsetDecoder newDecoder() {
        MabDisketteDecoder mabDisketteDecoder = new MabDisketteDecoder(this);
        return mabDisketteDecoder;
    }

    public class MabDisketteDecoder
    extends SingleByteDecoder {
        protected MabDisketteDecoder(Charset charset) {
            super(charset);
        }

        public char byteToChar(byte by) {
            return byteToCharTable[by & 0xFF];
        }

        public boolean isCombiningCharacter(byte by) {
            return false;
        }
    }

    public class MabDisketteEncoder
    extends CharsetEncoder {
        private boolean decomposeCharactersBeforeConversion;

        public boolean isDecomposeCharactersBeforeConversion() {
            return this.decomposeCharactersBeforeConversion;
        }

        public void setDecomposeCharactersBeforeConversion(boolean bl) {
            this.decomposeCharactersBeforeConversion = bl;
        }

        public MabDisketteEncoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
            this.decomposeCharactersBeforeConversion = true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            String string;
            int n = 0;
            String string2 = new String();
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                ++n;
                if (string2.length() > 0 && !this.isCombiningCharacter(c)) {
                    if (byteBuffer.remaining() < 1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("vor Berechnung => out.remaining(): " + byteBuffer.remaining() + ", in.position(): " + charBuffer.position() + ", numberOfInputCharsRead: " + n + " => Neue in.position=" + (charBuffer.position() - n)));
                        }
                        charBuffer.position(charBuffer.position() - n);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"encodeLoop() - overflow");
                        }
                        return CoderResult.OVERFLOW;
                    }
                    try {
                        MabDisketteCharset.this.normalizer = NormalizerFactory.getInstance();
                        string = MabDisketteCharset.this.normalizer.compose(string2);
                        if (this.charToByte(string.charAt(0)) != 0) {
                            this.convert(string.charAt(0), byteBuffer);
                        } else {
                            String string3 = MabDisketteCharset.this.normalizer.decompose(string2);
                            this.convert(string3.charAt(0), byteBuffer);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.convert(string2.charAt(0), byteBuffer);
                    }
                    n -= string2.length();
                    string2 = "";
                }
                string2 = string2 + String.valueOf(c);
            }
            if (string2.length() > 0) {
                if (byteBuffer.remaining() < 1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("vor Berechnung => out.remaining(): " + byteBuffer.remaining() + ", in.position(): " + charBuffer.position() + ", numberOfInputCharsRead: " + n + " => Neue in.position=" + (charBuffer.position() - n)));
                    }
                    charBuffer.position(charBuffer.position() - n);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"encodeLoop() - overflow");
                    }
                    return CoderResult.OVERFLOW;
                }
                try {
                    MabDisketteCharset.this.normalizer = NormalizerFactory.getInstance();
                    String string4 = MabDisketteCharset.this.normalizer.compose(string2);
                    if (this.charToByte(string4.charAt(0)) != 0) {
                        this.convert(string4.charAt(0), byteBuffer);
                    } else {
                        string = MabDisketteCharset.this.normalizer.decompose(string2);
                        this.convert(string.charAt(0), byteBuffer);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.convert(string2.charAt(0), byteBuffer);
                }
            }
            string2 = null;
            return CoderResult.UNDERFLOW;
        }

        public byte charToByte(char c) {
            Byte by = charToByteTable.get(Character.valueOf(c));
            if (by == null) {
                return 0;
            }
            return by;
        }

        public boolean isCombiningCharacter(char c) {
            return c >= '\u0300' && c <= '\u036f';
        }

        protected void convert(char c, ByteBuffer byteBuffer) {
            byte by = this.charToByte(c);
            if (by != 0) {
                byteBuffer.put(by);
            }
        }
    }
}

