/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import de.ddb.charset.SingleByteDecoder;
import de.ddb.charset.SingleByteEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MabCharset
extends Charset {
    public static final char SATZENDEZEICHEN = '\u001d';
    public static final char FELDENDEZEICHEN = '\u001e';
    public static final char UNTERFELDBEGINNZEICHEN = '\u001f';
    public static final char NICHTSORTIERBEGINNZEICHEN = '\u0098';
    public static final char NICHTSORTIERENDEZEICHEN = '\u009c';
    public static final char STICHWORTBEGINNZEICHEN = '{';
    public static final char STICHWORTENDEZEICHEN = '}';
    public static final char TEILFELDTRENNZEICHEN = '\u2021';
    static final char[] byteToCharTable = MabCharset.newMabCharsetMap();
    static final Map<Character, Byte> charToByteTable = MabCharset.newMabByteToCharMap();
    private boolean nfc = false;

    public MabCharset() {
        this(false);
    }

    public MabCharset(boolean bl) {
        super("x-MAB", null);
        this.nfc = bl;
    }

    private static Map<Character, Byte> newMabByteToCharMap() {
        HashMap<Character, Byte> hashMap = new HashMap<Character, Byte>(byteToCharTable.length);
        for (int i = 0; i < byteToCharTable.length; ++i) {
            if (byteToCharTable[i] == '\u0000' || hashMap.containsKey(Character.valueOf(byteToCharTable[i]))) continue;
            hashMap.put(new Character(byteToCharTable[i]), new Byte((byte)i));
        }
        hashMap.put(new Character('\u0308'), new Byte(-55));
        hashMap.put(new Character('$'), new Byte(-92));
        hashMap.put(new Character('\u00f0'), new Byte(-13));
        return hashMap;
    }

    private static char[] newMabCharsetMap() {
        char[] cArray = new char[256];
        for (int i = 0; i < 256; ++i) {
            cArray[i] = (char)i;
        }
        cArray[136] = 152;
        cArray[137] = 156;
        cArray[162] = 8222;
        cArray[164] = 36;
        cArray[166] = 8224;
        cArray[168] = 8242;
        cArray[169] = 8216;
        cArray[170] = 8220;
        cArray[172] = 9837;
        cArray[173] = 169;
        cArray[174] = 8471;
        cArray[175] = 174;
        cArray[176] = 699;
        cArray[177] = 700;
        cArray[178] = 8218;
        cArray[182] = 8225;
        cArray[184] = 8243;
        cArray[185] = 8217;
        cArray[186] = 8221;
        cArray[188] = 9839;
        cArray[189] = 697;
        cArray[190] = 698;
        cArray[192] = 777;
        cArray[193] = 768;
        cArray[194] = 769;
        cArray[195] = 770;
        cArray[196] = 771;
        cArray[197] = 772;
        cArray[198] = 774;
        cArray[199] = 775;
        cArray[200] = 776;
        cArray[201] = 776;
        cArray[202] = 778;
        cArray[203] = 789;
        cArray[204] = 786;
        cArray[205] = 779;
        cArray[206] = 795;
        cArray[207] = 780;
        cArray[208] = 807;
        cArray[209] = 796;
        cArray[210] = 806;
        cArray[211] = 808;
        cArray[212] = 805;
        cArray[213] = 814;
        cArray[214] = 803;
        cArray[215] = 804;
        cArray[216] = 818;
        cArray[217] = 819;
        cArray[218] = 809;
        cArray[219] = 813;
        cArray[221] = 65056;
        cArray[222] = 65057;
        cArray[223] = 65059;
        cArray[225] = 198;
        cArray[226] = 272;
        cArray[230] = 306;
        cArray[232] = 321;
        cArray[233] = 216;
        cArray[234] = 338;
        cArray[236] = 222;
        cArray[241] = 230;
        cArray[242] = 273;
        cArray[243] = 240;
        cArray[245] = 305;
        cArray[246] = 307;
        cArray[248] = 322;
        cArray[249] = 248;
        cArray[250] = 339;
        cArray[251] = 223;
        cArray[252] = 254;
        return cArray;
    }

    @Override
    public boolean contains(Charset charset) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        MabDecoder mabDecoder = new MabDecoder(this);
        mabDecoder.setComposeCharactersAfterConversion(this.nfc);
        return mabDecoder;
    }

    @Override
    public CharsetEncoder newEncoder() {
        MabEncoder mabEncoder = new MabEncoder(this);
        return mabEncoder;
    }

    class MabEncoder
    extends SingleByteEncoder {
        protected MabEncoder(Charset charset) {
            super(charset);
        }

        public byte charToByte(char c) {
            Byte by = charToByteTable.get(Character.valueOf(c));
            if (by == null) {
                return 0;
            }
            return by;
        }
    }

    class MabDecoder
    extends SingleByteDecoder {
        protected MabDecoder(Charset charset) {
            super(charset);
        }

        public char byteToChar(byte by) {
            return byteToCharTable[by & 0xFF];
        }

        public boolean isCombiningCharacter(byte by) {
            return (by & 0xFF) > 192 && (by & 0xFF) < 223;
        }
    }
}

